/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.hybrid.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.weight.GWS;

public class SimDagHybridUtils {
    Logger logger = LoggerFactory.getLogger(SimDagHybridUtils.class);

    public HashMap<URI, Double> computeSemanticContribution_Wang_2007(URI v, Set<URI> ancestors, G g, Set<URI> setEdgeTypes, GWS ws) {
        URI dest;
        Set edges;
        URI current;
        HashMap<URI, Double> sc = new HashMap<URI, Double>();
        HashMap<URI, Integer> inDegree = new HashMap<URI, Integer>();
        HashMap<URI, Integer> inDegreeDone = new HashMap<URI, Integer>();
        HashMap<URI, Boolean> visited = new HashMap<URI, Boolean>();
        for (URI c : ancestors) {
            visited.put(c, false);
            inDegree.put(c, 0);
            inDegreeDone.put(c, 0);
            sc.put(c, new Double(0.0));
        }
        ArrayList<URI> queue = new ArrayList<URI>();
        queue.add(v);
        visited.put(v, true);
        sc.put(v, new Double(1.0));
        while (!queue.isEmpty()) {
            current = (URI)queue.get(0);
            queue.remove(0);
            edges = g.getE(setEdgeTypes, current, Direction.OUT);
            for (E e : edges) {
                dest = e.getTarget();
                inDegree.put(dest, (Integer)inDegree.get(dest) + 1);
                if (((Boolean)visited.get(dest)).booleanValue()) continue;
                queue.add(dest);
                visited.put(dest, true);
            }
        }
        queue = new ArrayList();
        queue.add(v);
        while (!queue.isEmpty()) {
            current = (URI)queue.get(0);
            queue.remove(0);
            edges = g.getE(setEdgeTypes, current, Direction.OUT);
            for (E e : edges) {
                dest = e.getTarget();
                int done = (Integer)inDegreeDone.get(dest) + 1;
                inDegreeDone.put(dest, done);
                double new_sc = ws.getWeight(e) * sc.get(current);
                if (sc.get(dest) < new_sc) {
                    sc.put(dest, new_sc);
                }
                if (done != (Integer)inDegree.get(dest)) continue;
                queue.add(dest);
            }
        }
        return sc;
    }

    public double computeSV_Wang_2007(Map<URI, Double> sc) {
        double sum = 0.0;
        for (URI r : sc.keySet()) {
            sum += sc.get(r).doubleValue();
        }
        return sum;
    }
}

