/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.node_based;

import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_DAG_node_abstract;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class Sim_pairwise_DAG_node_GL
extends Sim_DAG_node_abstract {
    public static final String beta_param_name = "beta";
    private double beta = 0.0;

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        ICconf icConf = conf.getICconf();
        double ic_a = c.getIC(icConf, a);
        double ic_b = c.getIC(icConf, b);
        double ic_MICA = c.getIC_MICA(icConf, a, b);
        if (conf.containsParam(beta_param_name)) {
            this.beta = conf.getParamAsDouble(beta_param_name);
        }
        return this.sim(ic_a, ic_b, ic_MICA, this.beta);
    }

    public double sim(double ic_a, double ic_b, double ic_mica, double beta) throws SLIB_Ex_Critic {
        double den = ic_a + ic_b + (beta - 2.0) * ic_mica;
        double j = 0.0;
        if (den != 0.0) {
            j = beta * ic_mica / den;
        }
        return j;
    }

    @Override
    public Boolean isSymmetric() {
        return true;
    }
}

