/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.node_based.experimental;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_DAG_node_abstract;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_pairwise_DAG_node_Lin_1998;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class Sim_pairwise_DAG_node_Harispe_2013
extends Sim_DAG_node_abstract {
    public static final String aggregation_lca = "aggregation_lca";
    public static final String measure_param = "measure";
    public static final String[] acceptedMeasures = new String[]{"Resnik", "Lin"};
    public static final String[] acceptedAggregations = new String[]{"Max", "Min", "Avg", "Agg"};

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        double sim;
        if (!conf.containsParam(measure_param)) {
            throw new SLIB_Ex_Critic("Measure " + (Object)((Object)conf) + " requires a parameter '" + measure_param + "' to be defined");
        }
        String underlyingMeasure = (String)conf.getParam(measure_param);
        if (!conf.containsParam(aggregation_lca)) {
            throw new SLIB_Ex_Critic("Measure " + (Object)((Object)conf) + " requires a parameter '" + aggregation_lca + "' to be defined");
        }
        String aggregationLCAstrat = (String)conf.getParam(aggregation_lca);
        double ic_a = this.computeICpropagated(c, conf.getICconf(), a);
        double ic_b = this.computeICpropagated(c, conf.getICconf(), b);
        Set<URI> lca = c.getLCAs(a, b);
        double ic_lca = this.computeIcLCA(c, conf.getICconf(), lca, aggregationLCAstrat);
        if (underlyingMeasure.equals("Resnik")) {
            sim = ic_lca;
        } else if (underlyingMeasure.equals("Lin")) {
            sim = Sim_pairwise_DAG_node_Lin_1998.sim(ic_a, ic_b, ic_lca);
        } else {
            throw new SLIB_Ex_Critic("Measure " + underlyingMeasure + " is not a valid argument for the parameter '" + measure_param + "' in " + (Object)((Object)conf) + " pairwise measure configuration, accepted parameters are " + Arrays.toString(acceptedMeasures));
        }
        return sim;
    }

    private double computeICpropagated(SM_Engine engine, ICconf icConf, URI vertex) throws SLIB_Ex_Critic {
        Map<URI, Double> ics = engine.computeIC(icConf);
        double ic = 0.0;
        for (URI v : engine.getAncestorsInc(vertex)) {
            ic += ics.get(v).doubleValue();
        }
        return ic;
    }

    private double computeICpropagated(SM_Engine engine, ICconf icConf, Set<URI> vertices) throws SLIB_Ex_Critic {
        Map<URI, Double> ics = engine.computeIC(icConf);
        double ic = 0.0;
        for (URI v : engine.getAncestorsInc(vertices)) {
            ic += ics.get(v).doubleValue();
        }
        return ic;
    }

    private double computeIcLCA(SM_Engine c, ICconf conf, Set<URI> lca, String aggregation_lca_strategy) throws SLIB_Ex_Critic {
        double ic_lca = 0.0;
        if (aggregation_lca_strategy.equals("Max")) {
            double max = 0.0;
            for (URI v : lca) {
                double ic = this.computeICpropagated(c, conf, v);
                if (!(ic > max)) continue;
                max = ic;
            }
            ic_lca = max;
        } else if (aggregation_lca_strategy.equals("Min")) {
            Double min = null;
            for (URI v : lca) {
                double ic = this.computeICpropagated(c, conf, v);
                if (min != null && !(ic < min)) continue;
                min = ic;
            }
            ic_lca = min;
        } else if (aggregation_lca_strategy.equals("Avg")) {
            double avg = 0.0;
            for (URI v : lca) {
                avg += this.computeICpropagated(c, conf, v);
            }
            ic_lca = avg / (double)lca.size();
        } else if (aggregation_lca_strategy.equals("Agg")) {
            ic_lca = this.computeICpropagated(c, conf, lca);
        } else {
            throw new SLIB_Ex_Critic("Aggregation Strategy " + aggregation_lca_strategy + " is not a valid argument for the parameter '" + aggregation_lca + "', accepted parameters are " + Arrays.toString(acceptedAggregations));
        }
        return ic_lca;
    }
}

