/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.node_based.experimental;

import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_DAG_node_abstract;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class Sim_pairwise_DAG_node_Schlicker_GL_SimRel
extends Sim_DAG_node_abstract {
    public static final String beta_param_name = "beta";
    private double beta = 0.0;

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        ICconf confic;
        double ic_a = c.getIC(conf.getICconf(), a);
        double ic_b = c.getIC(conf.getICconf(), b);
        double ic_MICA = c.getIC_MICA(conf.getICconf(), a, b);
        if (conf.containsParam(beta_param_name)) {
            this.beta = conf.getParamAsDouble(beta_param_name);
        }
        if ((confic = (ICconf)((Object)conf.getParam("ic_prob"))) == null) {
            throw new SLIB_Ex_Critic("Measure " + this.getClass().getSimpleName() + " requires a parameter: " + "ic_prob");
        }
        double p_MICA = c.getP_MICA(confic, a, b);
        if (p_MICA < 0.0 || p_MICA > 1.0) {
            throw new SLIB_Ex_Critic("Probability measure is expected... Given IC " + confic.getId() + " is not suited as it apparently doesn't provide values restricted in [0,1] ");
        }
        return this.compare(ic_a, ic_b, ic_MICA, p_MICA, this.beta);
    }

    public double compare(double ic_a, double ic_b, double ic_mica, double p_mica, double beta) throws SLIB_Ex_Critic {
        double den = ic_a - ic_mica + (ic_b - ic_mica) + (2.0 - beta) * ic_mica;
        double j = 0.0;
        if (den != 0.0) {
            j = beta * ic_mica / den;
        }
        return j * (1.0 - p_mica);
    }
}

