/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.spring.boot;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueListenerBaseConfig;
import com.github.sonus21.rqueue.core.ReactiveRqueueMessageEnqueuer;
import com.github.sonus21.rqueue.core.RqueueEndpointManager;
import com.github.sonus21.rqueue.core.RqueueMessageEnqueuer;
import com.github.sonus21.rqueue.core.RqueueMessageManager;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.ReactiveRqueueMessageEnqueuerImpl;
import com.github.sonus21.rqueue.core.impl.RqueueEndpointManagerImpl;
import com.github.sonus21.rqueue.core.impl.RqueueMessageEnqueuerImpl;
import com.github.sonus21.rqueue.core.impl.RqueueMessageManagerImpl;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.utils.condition.ReactiveEnabled;
import com.github.sonus21.rqueue.utils.condition.RqueueEnabled;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ComponentScan(value={"com.github.sonus21.rqueue.web", "com.github.sonus21.rqueue.dao"})
@Conditional(value={RqueueEnabled.class})
public class RqueueListenerAutoConfig
extends RqueueListenerBaseConfig {
    @Bean
    @ConditionalOnMissingBean
    public RqueueMessageHandler rqueueMessageHandler() {
        return this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler(this.getMessageConverterProvider());
    }

    @Bean
    @DependsOn(value={"rqueueConfig"})
    @ConditionalOnMissingBean
    public RqueueMessageListenerContainer rqueueMessageListenerContainer(RqueueMessageHandler rqueueMessageHandler) {
        this.simpleRqueueListenerContainerFactory.setRqueueMessageHandler(rqueueMessageHandler);
        return this.simpleRqueueListenerContainerFactory.createMessageListenerContainer();
    }

    @Bean
    @ConditionalOnMissingBean
    public RqueueMessageTemplate rqueueMessageTemplate(RqueueConfig rqueueConfig, RqueueMessageHandler rqueueMessageHandler) {
        return this.getMessageTemplate(rqueueConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public RqueueMessageManager rqueueMessageManager(RqueueMessageHandler rqueueMessageHandler, RqueueMessageTemplate rqueueMessageTemplate) {
        return new RqueueMessageManagerImpl(rqueueMessageTemplate, rqueueMessageHandler.getMessageConverter(), this.simpleRqueueListenerContainerFactory.getMessageHeaders());
    }

    @Bean
    @ConditionalOnMissingBean
    public RqueueEndpointManager rqueueEndpointManager(RqueueMessageHandler rqueueMessageHandler, RqueueMessageTemplate rqueueMessageTemplate) {
        return new RqueueEndpointManagerImpl(rqueueMessageTemplate, rqueueMessageHandler.getMessageConverter(), this.simpleRqueueListenerContainerFactory.getMessageHeaders());
    }

    @Bean
    @ConditionalOnMissingBean
    public RqueueMessageEnqueuer rqueueMessageEnqueuer(RqueueMessageHandler rqueueMessageHandler, RqueueMessageTemplate rqueueMessageTemplate) {
        return new RqueueMessageEnqueuerImpl(rqueueMessageTemplate, rqueueMessageHandler.getMessageConverter(), this.simpleRqueueListenerContainerFactory.getMessageHeaders());
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={ReactiveEnabled.class})
    public ReactiveRqueueMessageEnqueuer reactiveRqueueMessageEnqueuer(RqueueMessageHandler rqueueMessageHandler, RqueueMessageTemplate rqueueMessageTemplate) {
        return new ReactiveRqueueMessageEnqueuerImpl(rqueueMessageTemplate, rqueueMessageHandler.getMessageConverter(), this.simpleRqueueListenerContainerFactory.getMessageHeaders());
    }
}

