/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.spring.boot;

import com.github.sonus21.rqueue.metrics.QueueCounter;
import com.github.sonus21.rqueue.metrics.RqueueCounter;
import com.github.sonus21.rqueue.metrics.RqueueMetrics;
import com.github.sonus21.rqueue.metrics.RqueueMetricsCounter;
import com.github.sonus21.rqueue.metrics.RqueueMetricsRegistry;
import com.github.sonus21.rqueue.spring.boot.RqueueMetricsProperties;
import com.github.sonus21.rqueue.utils.condition.RqueueEnabled;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={MeterRegistry.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@Import(value={RqueueMetricsProperties.class})
@Conditional(value={RqueueEnabled.class})
public class RqueueMetricsAutoConfig {
    @Bean
    public RqueueMetricsRegistry rqueueMetricsRegistry(MetricsProperties metricsProperties, RqueueMetricsProperties rqueueMetricsProperties) {
        Tags actualTags = Tags.empty();
        for (Map.Entry<String, String> entry : this.getTags(metricsProperties).entrySet()) {
            actualTags = Tags.concat((Iterable)actualTags, (String[])new String[]{entry.getKey(), entry.getValue()});
        }
        for (Map.Entry<String, String> entry : rqueueMetricsProperties.getTags().entrySet()) {
            actualTags = Tags.concat((Iterable)actualTags, (String[])new String[]{entry.getKey(), entry.getValue()});
        }
        rqueueMetricsProperties.setMetricTags(actualTags);
        QueueCounter queueCounter = new QueueCounter();
        return new RqueueMetrics(queueCounter);
    }

    private Map<String, String> getTags(MetricsProperties metricsProperties) {
        try {
            Method method = MetricsProperties.class.getMethod("getTags", new Class[0]);
            return (Map)method.invoke((Object)metricsProperties, new Object[0]);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    @Bean
    public RqueueMetricsCounter rqueueMetricsCounter(RqueueMetricsRegistry rqueueMetricsRegistry) {
        return new RqueueCounter(rqueueMetricsRegistry.getQueueCounter());
    }
}

