/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.latvia;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeUtils;
import com.github.vladislavgoltjajev.personalcode.utility.DateUtils;
import java.time.LocalDate;
import java.util.Random;

public final class LatvianPersonalCodeGenerator {
    public String generateRandomPersonalCode() {
        int identifier = new Random().nextInt(1000000000);
        String personalCode = "32" + String.format("%09d", identifier);
        if (Math.random() > 0.5) {
            personalCode = personalCode.substring(0, 6) + "-" + personalCode.substring(6);
        }
        return personalCode;
    }

    public String generateRandomLegacyPersonalCode() {
        try {
            return this.generateLegacyPersonalCode(LatvianPersonalCodeUtils.getRandomDateOfBirth(), LatvianPersonalCodeUtils.getRandomBirthOrderNumber());
        }
        catch (PersonalCodeException e) {
            throw new RuntimeException(e);
        }
    }

    public String generateLegacyPersonalCode(LocalDate dateOfBirth) throws PersonalCodeException {
        return this.generateLegacyPersonalCode(dateOfBirth, LatvianPersonalCodeUtils.getRandomBirthOrderNumber());
    }

    public String generateLegacyPersonalCode(LocalDate dateOfBirth, int birthOrderNumber) throws PersonalCodeException {
        if (dateOfBirth == null || dateOfBirth.isBefore(LatvianPersonalCodeConstants.MINIMUM_LEGACY_DATE) || dateOfBirth.isAfter(LatvianPersonalCodeConstants.MAXIMUM_LEGACY_DATE)) {
            throw new PersonalCodeException(String.format("Date of birth must be between %s and %s", DateUtils.getReadableFormatDate(LatvianPersonalCodeConstants.MINIMUM_LEGACY_DATE), DateUtils.getReadableFormatDate(LatvianPersonalCodeConstants.MAXIMUM_LEGACY_DATE)));
        }
        if (birthOrderNumber < 0 || birthOrderNumber > 999) {
            throw new PersonalCodeException("Birth order number must be between 0 and 999");
        }
        String dateString = dateOfBirth.format(LatvianPersonalCodeConstants.LEGACY_DATE_FORMATTER);
        String personalCodeWithoutChecksum = dateString.substring(0, 4) + dateString.substring(6) + "-" + LatvianPersonalCodeUtils.getCenturyIdentifier(dateOfBirth) + String.format("%03d", birthOrderNumber);
        return personalCodeWithoutChecksum + LatvianPersonalCodeUtils.getChecksum(personalCodeWithoutChecksum);
    }
}

