/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.latvia;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeValidator;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;

public final class LatvianPersonalCodeParser {
    public LocalDate getDateOfBirth(String personalCode) throws PersonalCodeException {
        return this.getDateOfBirth(personalCode, true);
    }

    LocalDate getDateOfBirth(String personalCode, boolean validate) throws PersonalCodeException {
        String yearStart;
        if (validate) {
            this.validatePersonalCode(personalCode);
        }
        switch (this.getCenturyIdentifier(personalCode)) {
            case 0: {
                yearStart = "18";
                break;
            }
            case 1: {
                yearStart = "19";
                break;
            }
            default: {
                yearStart = "20";
            }
        }
        String dateString = personalCode.substring(0, 4) + yearStart + personalCode.substring(4, 6);
        try {
            return LocalDate.parse(dateString, LatvianPersonalCodeConstants.LEGACY_DATE_FORMATTER);
        }
        catch (DateTimeParseException e) {
            throw new PersonalCodeException(e.getMessage());
        }
    }

    public Period getAge(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        LocalDate dateOfBirth = this.getDateOfBirth(personalCode);
        if (dateOfBirth.isAfter(LocalDate.now())) {
            throw new PersonalCodeException("Date of birth is after the introduction of the updated Latvian personal code format");
        }
        return Period.between(dateOfBirth, LocalDate.now());
    }

    public int getBirthOrderNumber(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        return Integer.parseInt(personalCode.substring(8, 11));
    }

    private int getCenturyIdentifier(String personalCode) {
        return Character.getNumericValue(personalCode.charAt(7));
    }

    private void validatePersonalCode(String personalCode) throws PersonalCodeException {
        LatvianPersonalCodeValidator validator = new LatvianPersonalCodeValidator();
        if (validator.isValidUpdatedPersonalCode(personalCode)) {
            throw new PersonalCodeException("Cannot extract data from updated Latvian personal codes");
        }
        if (!validator.isValidLegacyPersonalCode(personalCode)) {
            throw new PersonalCodeException("Invalid legacy Latvian personal code");
        }
    }
}

