/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.latvia;

import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.utility.DateUtils;
import java.time.LocalDate;
import java.util.Random;
import java.util.stream.Stream;

final class LatvianPersonalCodeUtils {
    static int getChecksum(String personalCode) {
        int[] numberArray = Stream.of(personalCode.replace("-", "").substring(0, 10).split("")).mapToInt(Integer::parseInt).toArray();
        int sum = 0;
        int[] multipliers = new int[]{1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        for (int i = 0; i < numberArray.length; ++i) {
            sum += numberArray[i] * multipliers[i];
        }
        return (1101 - sum) % 11 % 10;
    }

    static int getCenturyIdentifier(LocalDate dateOfBirth) {
        int birthYear = dateOfBirth.getYear();
        if (birthYear >= 1800 && birthYear <= 1899) {
            return 0;
        }
        if (birthYear >= 1900 && birthYear <= 1999) {
            return 1;
        }
        return 2;
    }

    static LocalDate getRandomDateOfBirth() {
        return DateUtils.getRandomDate(LatvianPersonalCodeConstants.MINIMUM_LEGACY_DATE, LatvianPersonalCodeConstants.MAXIMUM_LEGACY_DATE);
    }

    static int getRandomBirthOrderNumber() {
        return new Random().nextInt(1000);
    }

    private LatvianPersonalCodeUtils() {
    }
}

