/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.latvia;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeParser;
import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeUtils;

public final class LatvianPersonalCodeValidator {
    public boolean isValid(String personalCode) {
        return this.isValidUpdatedPersonalCode(personalCode) || this.isValidLegacyPersonalCode(personalCode);
    }

    public boolean isValidUpdatedPersonalCode(String personalCode) {
        return personalCode != null && !personalCode.isBlank() && personalCode.matches("^32\\d{4}-?\\d{5}$");
    }

    public boolean isValidLegacyPersonalCode(String personalCode) {
        if (!this.isLegacyFormatValid(personalCode)) {
            return false;
        }
        try {
            new LatvianPersonalCodeParser().getDateOfBirth(personalCode, false);
        }
        catch (PersonalCodeException e) {
            return false;
        }
        int checksum = Character.getNumericValue(personalCode.charAt(personalCode.length() - 1));
        return checksum == LatvianPersonalCodeUtils.getChecksum(personalCode);
    }

    public boolean isLegacyFormatValid(String personalCode) {
        return personalCode != null && !personalCode.isBlank() && personalCode.matches("^(((0[1-9]|[12]\\d|3[01])(0[13578]|1[02]))|((0[1-9]|[12]\\d|30)(0[469]|11))|((0[1-9]|1\\d|2[0-9])02))\\d{2}-[0-2]\\d{4}$");
    }
}

