/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.lithuania;

import com.github.vladislavgoltjajev.personalcode.enums.Gender;
import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.lithuania.LithuanianPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.locale.lithuania.LithuanianPersonalCodeUtils;
import com.github.vladislavgoltjajev.personalcode.utility.DateUtils;
import java.time.LocalDate;

public final class LithuanianPersonalCodeGenerator {
    public String generateRandomPersonalCode() {
        try {
            return this.generatePersonalCode(LithuanianPersonalCodeUtils.getRandomGender(), LithuanianPersonalCodeUtils.getRandomDateOfBirth(), LithuanianPersonalCodeUtils.getRandomBirthOrderNumber());
        }
        catch (PersonalCodeException e) {
            throw new RuntimeException(e);
        }
    }

    public String generatePersonalCode(Gender gender, LocalDate dateOfBirth) throws PersonalCodeException {
        return this.generatePersonalCode(gender, dateOfBirth, LithuanianPersonalCodeUtils.getRandomBirthOrderNumber());
    }

    public String generatePersonalCode(Gender gender, LocalDate dateOfBirth, int birthOrderNumber) throws PersonalCodeException {
        if (dateOfBirth == null || dateOfBirth.isBefore(LithuanianPersonalCodeConstants.MINIMUM_DATE) || dateOfBirth.isAfter(LithuanianPersonalCodeConstants.MAXIMUM_DATE)) {
            throw new PersonalCodeException(String.format("Date of birth must be between %s and %s", DateUtils.getReadableFormatDate(LithuanianPersonalCodeConstants.MINIMUM_DATE), DateUtils.getReadableFormatDate(LithuanianPersonalCodeConstants.MAXIMUM_DATE)));
        }
        if (birthOrderNumber < 0 || birthOrderNumber > 999) {
            throw new PersonalCodeException("Birth order number must be between 0 and 999");
        }
        String personalCodeWithoutChecksum = LithuanianPersonalCodeUtils.getGenderIdentifier(gender, dateOfBirth) + dateOfBirth.format(LithuanianPersonalCodeConstants.DATE_FORMATTER).substring(2) + String.format("%03d", birthOrderNumber);
        return personalCodeWithoutChecksum + LithuanianPersonalCodeUtils.getChecksum(personalCodeWithoutChecksum);
    }
}

