/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.utility;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoUnit;

public final class DateUtils {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.uuuu").withResolverStyle(ResolverStyle.STRICT);

    public static String getReadableFormatDate(LocalDate date) {
        return date.format(DATE_FORMATTER);
    }

    public static LocalDate getRandomDate(LocalDate startDate, LocalDate endDate) {
        long leftLimit = 0L;
        long rightLimit = ChronoUnit.DAYS.between(startDate, endDate);
        long generatedLong = leftLimit + (long)(Math.random() * (double)(rightLimit - leftLimit));
        return startDate.plusDays(generatedLong);
    }

    private DateUtils() {
    }
}

