/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.estonia;

import com.github.vladislavgoltjajev.personalcode.common.Gender;
import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.estonia.EstonianPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.locale.estonia.EstonianPersonalCodeUtils;
import com.github.vladislavgoltjajev.personalcode.utility.DateUtils;
import com.github.vladislavgoltjajev.personalcode.utility.NumberUtils;
import java.time.LocalDate;

public class EstonianPersonalCodeGenerator {
    public String generateRandomPersonalCode() {
        try {
            return this.generatePersonalCode(Gender.getRandomGender(), EstonianPersonalCodeUtils.getRandomDateOfBirth(), EstonianPersonalCodeUtils.getRandomBirthOrderNumber());
        }
        catch (PersonalCodeException e) {
            throw new RuntimeException(e);
        }
    }

    public String generatePersonalCode(Gender gender) throws PersonalCodeException {
        return this.generatePersonalCode(gender, EstonianPersonalCodeUtils.getRandomDateOfBirth(), EstonianPersonalCodeUtils.getRandomBirthOrderNumber());
    }

    public String generatePersonalCode(Gender gender, LocalDate dateOfBirth) throws PersonalCodeException {
        return this.generatePersonalCode(gender, dateOfBirth, EstonianPersonalCodeUtils.getRandomBirthOrderNumber());
    }

    public String generatePersonalCode(Gender gender, LocalDate dateOfBirth, int birthOrderNumber) throws PersonalCodeException {
        if (gender == null) {
            throw new PersonalCodeException("Gender must be specified");
        }
        if (dateOfBirth == null) {
            throw new PersonalCodeException("Date of birth must be specified");
        }
        if (dateOfBirth.isBefore(EstonianPersonalCodeConstants.MINIMUM_DATE) || dateOfBirth.isAfter(EstonianPersonalCodeConstants.MAXIMUM_DATE)) {
            throw new PersonalCodeException(String.format("Date of birth must be between %s and %s", DateUtils.getReadableFormatDate(EstonianPersonalCodeConstants.MINIMUM_DATE), DateUtils.getReadableFormatDate(EstonianPersonalCodeConstants.MAXIMUM_DATE)));
        }
        if (birthOrderNumber < 0 || birthOrderNumber > 999) {
            throw new PersonalCodeException("Birth order number must be between 0 and 999");
        }
        String personalCodeWithoutChecksum = EstonianPersonalCodeUtils.getGenderIdentifier(gender, dateOfBirth) + dateOfBirth.format(EstonianPersonalCodeConstants.DATE_FORMATTER).substring(2) + NumberUtils.getNumberWithLeadingZeroes(birthOrderNumber, 3);
        return personalCodeWithoutChecksum + EstonianPersonalCodeUtils.getChecksum(personalCodeWithoutChecksum);
    }
}

