/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.estonia;

import com.github.vladislavgoltjajev.personalcode.common.Gender;
import com.github.vladislavgoltjajev.personalcode.locale.estonia.EstonianPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.utility.DateUtils;
import java.time.LocalDate;
import java.util.Random;
import java.util.stream.Stream;

class EstonianPersonalCodeUtils {
    static int getChecksum(String personalCode) {
        int[] digits = Stream.of(personalCode.split("")).mapToInt(Integer::parseInt).toArray();
        int sum = 0;
        int[] multipliers = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 1};
        for (int i = 0; i < digits.length; ++i) {
            sum += digits[i] * multipliers[i];
        }
        int checksum = sum % 11;
        if (checksum == 10) {
            sum = 0;
            multipliers = new int[]{3, 4, 5, 6, 7, 8, 9, 1, 2, 3};
            for (int i = 0; i < digits.length; ++i) {
                sum += digits[i] * multipliers[i];
            }
            checksum = sum % 11;
            if (checksum == 10) {
                return 0;
            }
        }
        return checksum;
    }

    static int getGenderIdentifier(Gender gender, LocalDate dateOfBirth) {
        int birthYear = dateOfBirth.getYear();
        boolean isMale = Gender.MALE.equals((Object)gender);
        if (birthYear >= 1800 && birthYear <= 1899) {
            return isMale ? 1 : 2;
        }
        if (birthYear >= 1900 && birthYear <= 1999) {
            return isMale ? 3 : 4;
        }
        return isMale ? 5 : 6;
    }

    static LocalDate getRandomDateOfBirth() {
        return DateUtils.getRandomDate(EstonianPersonalCodeConstants.MINIMUM_DATE, EstonianPersonalCodeConstants.MAXIMUM_DATE);
    }

    static int getRandomBirthOrderNumber() {
        return new Random().nextInt(1000);
    }

    private EstonianPersonalCodeUtils() {
    }
}

