/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.estonia;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.estonia.EstonianPersonalCodeParser;
import com.github.vladislavgoltjajev.personalcode.locale.estonia.EstonianPersonalCodeUtils;

public class EstonianPersonalCodeValidator {
    public boolean isValid(String personalCode) {
        if (!this.isValidFormat(personalCode)) {
            return false;
        }
        try {
            new EstonianPersonalCodeParser().getDateOfBirth(personalCode, false);
        }
        catch (PersonalCodeException e) {
            return false;
        }
        int checksum = Character.getNumericValue(personalCode.charAt(personalCode.length() - 1));
        return checksum == EstonianPersonalCodeUtils.getChecksum(personalCode.substring(0, 10));
    }

    public boolean isValidFormat(String personalCode) {
        return personalCode != null && !personalCode.isBlank() && personalCode.matches("^[1-6]\\d{2}(((0[13578]|1[02])(0[1-9]|[12]\\d|3[01]))|((0[469]|11)(0[1-9]|[12]\\d|30))|(02(0[1-9]|1\\d|2[0-9])))\\d{4}$");
    }
}

