/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.india;

import com.github.vladislavgoltjajev.personalcode.utility.ChecksumUtils;

public class IndianPersonalCodeValidator {
    public boolean isValid(String personalCode) {
        if (!this.isValidFormat(personalCode)) {
            return false;
        }
        int checksum = Character.getNumericValue(personalCode.charAt(personalCode.length() - 1));
        return checksum == ChecksumUtils.getVerhoeffChecksum(personalCode.replaceAll("-", "").substring(0, 11));
    }

    public boolean isValidFormat(String personalCode) {
        return personalCode != null && !personalCode.isBlank() && personalCode.matches("^\\d{4}-\\d{4}-\\d{4}$");
    }
}

