/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.latvia;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.locale.latvia.LatvianPersonalCodeUtils;
import com.github.vladislavgoltjajev.personalcode.utility.BooleanUtils;
import com.github.vladislavgoltjajev.personalcode.utility.DateUtils;
import com.github.vladislavgoltjajev.personalcode.utility.NumberUtils;
import java.time.LocalDate;

public class LatvianPersonalCodeGenerator {
    public String generateRandomPersonalCode() {
        return BooleanUtils.get50PercentChance() ? this.generateRandomUpdatedPersonalCode() : this.generateRandomLegacyPersonalCode();
    }

    public String generateRandomUpdatedPersonalCode() {
        return this.generateRandomUpdatedPersonalCode(BooleanUtils.get50PercentChance());
    }

    public String generateRandomUpdatedPersonalCode(boolean addDash) {
        String personalCodeWithoutChecksum = "32" + NumberUtils.getRandomNumberWithLeadingZeroes(8);
        String personalCode = personalCodeWithoutChecksum + LatvianPersonalCodeUtils.getChecksum(personalCodeWithoutChecksum);
        if (addDash) {
            personalCode = personalCode.substring(0, 6) + "-" + personalCode.substring(6);
        }
        return personalCode;
    }

    public String generateRandomLegacyPersonalCode() {
        try {
            return this.generateLegacyPersonalCode(LatvianPersonalCodeUtils.getRandomDateOfBirth(), LatvianPersonalCodeUtils.getRandomBirthOrderNumber());
        }
        catch (PersonalCodeException e) {
            throw new RuntimeException(e);
        }
    }

    public String generateLegacyPersonalCode(LocalDate dateOfBirth) throws PersonalCodeException {
        return this.generateLegacyPersonalCode(dateOfBirth, LatvianPersonalCodeUtils.getRandomBirthOrderNumber());
    }

    public String generateLegacyPersonalCode(LocalDate dateOfBirth, int birthOrderNumber) throws PersonalCodeException {
        if (dateOfBirth == null) {
            throw new PersonalCodeException("Date of birth must be specified");
        }
        if (dateOfBirth.isBefore(LatvianPersonalCodeConstants.MINIMUM_LEGACY_DATE) || dateOfBirth.isAfter(LatvianPersonalCodeConstants.MAXIMUM_LEGACY_DATE)) {
            throw new PersonalCodeException(String.format("Date of birth must be between %s and %s", DateUtils.getReadableFormatDate(LatvianPersonalCodeConstants.MINIMUM_LEGACY_DATE), DateUtils.getReadableFormatDate(LatvianPersonalCodeConstants.MAXIMUM_LEGACY_DATE)));
        }
        if (birthOrderNumber < 0 || birthOrderNumber > 999) {
            throw new PersonalCodeException("Birth order number must be between 0 and 999");
        }
        String dateString = dateOfBirth.format(LatvianPersonalCodeConstants.LEGACY_DATE_FORMATTER);
        String personalCodeWithoutChecksum = dateString.substring(0, 4) + dateString.substring(6) + "-" + LatvianPersonalCodeUtils.getCenturyIdentifier(dateOfBirth) + NumberUtils.getNumberWithLeadingZeroes(birthOrderNumber, 3);
        return personalCodeWithoutChecksum + LatvianPersonalCodeUtils.getChecksum(personalCodeWithoutChecksum);
    }
}

