/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.lithuania;

import com.github.vladislavgoltjajev.personalcode.common.Gender;
import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.lithuania.LithuanianPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.locale.lithuania.LithuanianPersonalCodeValidator;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;

public class LithuanianPersonalCodeParser {
    public Gender getGender(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        switch (this.getGenderIdentifier(personalCode)) {
            case 1: 
            case 3: 
            case 5: {
                return Gender.MALE;
            }
        }
        return Gender.FEMALE;
    }

    public LocalDate getDateOfBirth(String personalCode) throws PersonalCodeException {
        return this.getDateOfBirth(personalCode, true);
    }

    LocalDate getDateOfBirth(String personalCode, boolean validate) throws PersonalCodeException {
        if (validate) {
            this.validatePersonalCode(personalCode);
        }
        Object dateString = personalCode.substring(1, 7);
        switch (this.getGenderIdentifier(personalCode)) {
            case 1: 
            case 2: {
                dateString = "18" + (String)dateString;
                break;
            }
            case 3: 
            case 4: {
                dateString = "19" + (String)dateString;
                break;
            }
            default: {
                dateString = "20" + (String)dateString;
            }
        }
        try {
            return LocalDate.parse((CharSequence)dateString, LithuanianPersonalCodeConstants.DATE_FORMATTER);
        }
        catch (DateTimeParseException e) {
            throw new PersonalCodeException(e.getMessage());
        }
    }

    public Period getAge(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        LocalDate dateOfBirth = this.getDateOfBirth(personalCode);
        if (dateOfBirth.isAfter(LocalDate.now())) {
            throw new PersonalCodeException("Date of birth is in the future");
        }
        return Period.between(dateOfBirth, LocalDate.now());
    }

    public int getBirthOrderNumber(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        return Integer.parseInt(personalCode.substring(7, 10));
    }

    private int getGenderIdentifier(String personalCode) {
        return Character.getNumericValue(personalCode.charAt(0));
    }

    private void validatePersonalCode(String personalCode) throws PersonalCodeException {
        if (!new LithuanianPersonalCodeValidator().isValid(personalCode)) {
            throw new PersonalCodeException("Invalid Lithuanian personal code");
        }
    }
}

