/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.luxembourg;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.luxembourg.LuxembourgishPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.locale.luxembourg.LuxembourgishPersonalCodeUtils;
import com.github.vladislavgoltjajev.personalcode.utility.NumberUtils;
import java.time.LocalDate;

public class LuxembourgishPersonalCodeGenerator {
    public String generateRandomPersonalCode() {
        try {
            return this.generatePersonalCode(LuxembourgishPersonalCodeUtils.getRandomDateOfBirth(), LuxembourgishPersonalCodeUtils.getRandomBirthOrderNumber());
        }
        catch (PersonalCodeException e) {
            throw new RuntimeException(e);
        }
    }

    public String generatePersonalCode(LocalDate dateOfBirth) throws PersonalCodeException {
        return this.generatePersonalCode(dateOfBirth, LuxembourgishPersonalCodeUtils.getRandomBirthOrderNumber());
    }

    public String generatePersonalCode(LocalDate dateOfBirth, int birthOrderNumber) throws PersonalCodeException {
        if (dateOfBirth == null) {
            throw new PersonalCodeException("Date of birth must be specified");
        }
        if (birthOrderNumber < 0 || birthOrderNumber > 999) {
            throw new PersonalCodeException("Birth order number must be between 0 and 999");
        }
        String personalCodeWithoutChecksum = dateOfBirth.format(LuxembourgishPersonalCodeConstants.DATE_FORMATTER) + NumberUtils.getNumberWithLeadingZeroes(birthOrderNumber, 3);
        return personalCodeWithoutChecksum + LuxembourgishPersonalCodeUtils.getChecksum(personalCodeWithoutChecksum);
    }
}

