/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.luxembourg;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.luxembourg.LuxembourgishPersonalCodeConstants;
import com.github.vladislavgoltjajev.personalcode.locale.luxembourg.LuxembourgishPersonalCodeValidator;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;

public class LuxembourgishPersonalCodeParser {
    public LocalDate getDateOfBirth(String personalCode) throws PersonalCodeException {
        return this.getDateOfBirth(personalCode, true);
    }

    LocalDate getDateOfBirth(String personalCode, boolean validate) throws PersonalCodeException {
        if (validate) {
            this.validatePersonalCode(personalCode);
        }
        try {
            return LocalDate.parse(personalCode.substring(0, 8), LuxembourgishPersonalCodeConstants.DATE_FORMATTER);
        }
        catch (DateTimeParseException e) {
            throw new PersonalCodeException(e.getMessage());
        }
    }

    public Period getAge(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        LocalDate dateOfBirth = this.getDateOfBirth(personalCode);
        if (dateOfBirth.isAfter(LocalDate.now())) {
            throw new PersonalCodeException("Date of birth is in the future");
        }
        return Period.between(dateOfBirth, LocalDate.now());
    }

    public int getBirthOrderNumber(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        return Integer.parseInt(personalCode.substring(8, 11));
    }

    private void validatePersonalCode(String personalCode) throws PersonalCodeException {
        LuxembourgishPersonalCodeValidator validator = new LuxembourgishPersonalCodeValidator();
        if (!validator.isValid(personalCode)) {
            throw new PersonalCodeException("Invalid Luxembourgish personal code");
        }
    }
}

