/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.luxembourg;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.luxembourg.LuxembourgishPersonalCodeParser;
import com.github.vladislavgoltjajev.personalcode.locale.luxembourg.LuxembourgishPersonalCodeUtils;

public class LuxembourgishPersonalCodeValidator {
    public boolean isValid(String personalCode) {
        if (!this.isValidFormat(personalCode)) {
            return false;
        }
        try {
            new LuxembourgishPersonalCodeParser().getDateOfBirth(personalCode, false);
        }
        catch (PersonalCodeException e) {
            return false;
        }
        String checksum = personalCode.substring(personalCode.length() - 2);
        return checksum.equals(LuxembourgishPersonalCodeUtils.getChecksum(personalCode.substring(0, 11)));
    }

    public boolean isValidFormat(String personalCode) {
        return personalCode != null && !personalCode.isBlank() && personalCode.matches("^\\d{4}(((0[13578]|1[02])(0[1-9]|[12]\\d|3[01]))|((0[469]|11)(0[1-9]|[12]\\d|30))|(02(0[1-9]|1\\d|2[0-9])))\\d{5}$");
    }
}

