/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.taiwan;

import com.github.vladislavgoltjajev.personalcode.common.Gender;
import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.taiwan.TaiwanesePersonalCodeUtils;
import com.github.vladislavgoltjajev.personalcode.locale.taiwan.TaiwaneseRegion;
import com.github.vladislavgoltjajev.personalcode.utility.NumberUtils;

public class TaiwanesePersonalCodeGenerator {
    public String generateRandomPersonalCode() {
        try {
            return this.generatePersonalCode(TaiwaneseRegion.getRandomRegion(), Gender.getRandomGender());
        }
        catch (PersonalCodeException e) {
            throw new RuntimeException(e);
        }
    }

    public String generatePersonalCode(TaiwaneseRegion region) throws PersonalCodeException {
        return this.generatePersonalCode(region, Gender.getRandomGender());
    }

    public String generatePersonalCode(Gender gender) throws PersonalCodeException {
        return this.generatePersonalCode(TaiwaneseRegion.getRandomRegion(), gender);
    }

    public String generatePersonalCode(TaiwaneseRegion region, Gender gender) throws PersonalCodeException {
        return this.generatePersonalCode(region, gender, false);
    }

    public String generatePersonalCode(TaiwaneseRegion region, Gender gender, boolean checkRegionValidity) throws PersonalCodeException {
        if (region == null) {
            throw new PersonalCodeException("Household registration region must be specified");
        }
        if (checkRegionValidity && !region.isIssued()) {
            throw new PersonalCodeException("Deprecated household registration region");
        }
        if (gender == null) {
            throw new PersonalCodeException("Gender must be specified");
        }
        String personalCodeWithoutChecksum = region.getCode() + TaiwanesePersonalCodeUtils.getGenderIdentifier(gender) + NumberUtils.getRandomNumberWithLeadingZeroes(7);
        return personalCodeWithoutChecksum + TaiwanesePersonalCodeUtils.getChecksum(personalCodeWithoutChecksum);
    }
}

