/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.taiwan;

import com.github.vladislavgoltjajev.personalcode.common.Gender;
import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.taiwan.TaiwanesePersonalCodeUtils;
import com.github.vladislavgoltjajev.personalcode.locale.taiwan.TaiwanesePersonalCodeValidator;
import com.github.vladislavgoltjajev.personalcode.locale.taiwan.TaiwaneseRegion;

public class TaiwanesePersonalCodeParser {
    public TaiwaneseRegion getHouseholdRegistrationRegion(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        return TaiwanesePersonalCodeUtils.getHouseholdRegistrationRegion(personalCode);
    }

    public Gender getGender(String personalCode) throws PersonalCodeException {
        this.validatePersonalCode(personalCode);
        return Character.getNumericValue(personalCode.charAt(1)) == 1 ? Gender.MALE : Gender.FEMALE;
    }

    private void validatePersonalCode(String personalCode) throws PersonalCodeException {
        if (!new TaiwanesePersonalCodeValidator().isValid(personalCode)) {
            throw new PersonalCodeException("Invalid Taiwanese personal code");
        }
    }
}

