/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.taiwan;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.taiwan.TaiwanesePersonalCodeUtils;

public class TaiwanesePersonalCodeValidator {
    public boolean isValid(String personalCode) {
        if (!this.isValidFormat(personalCode)) {
            return false;
        }
        int checksum = Character.getNumericValue(personalCode.charAt(personalCode.length() - 1));
        try {
            return checksum == TaiwanesePersonalCodeUtils.getChecksum(personalCode);
        }
        catch (PersonalCodeException e) {
            return false;
        }
    }

    public boolean isValidFormat(String personalCode) {
        return personalCode != null && !personalCode.isBlank() && personalCode.matches("^[A-Z][1-2]\\d{8}$");
    }
}

