/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.uae;

import com.github.vladislavgoltjajev.personalcode.exception.PersonalCodeException;
import com.github.vladislavgoltjajev.personalcode.locale.uae.EmiratiPersonalCodeUtils;
import com.github.vladislavgoltjajev.personalcode.utility.ChecksumUtils;
import com.github.vladislavgoltjajev.personalcode.utility.NumberUtils;
import java.time.LocalDate;

public class EmiratiPersonalCodeGenerator {
    public String generateRandomPersonalCode() {
        try {
            return this.generatePersonalCode(EmiratiPersonalCodeUtils.getRandomYearOfBirth());
        }
        catch (PersonalCodeException e) {
            throw new RuntimeException(e);
        }
    }

    public String generatePersonalCode(LocalDate dateOfBirth) throws PersonalCodeException {
        if (dateOfBirth == null) {
            throw new PersonalCodeException("Date of birth must be specified");
        }
        return this.generatePersonalCode(dateOfBirth.getYear());
    }

    public String generatePersonalCode(int birthYear) throws PersonalCodeException {
        if (birthYear < 0 || birthYear > 9999) {
            throw new PersonalCodeException("Invalid birth year");
        }
        String personalCodeWithoutChecksum = "784-" + NumberUtils.getNumberWithLeadingZeroes(birthYear, 4) + "-" + NumberUtils.getRandomNumberWithLeadingZeroes(7);
        return personalCodeWithoutChecksum + "-" + ChecksumUtils.getLuhnChecksum(personalCodeWithoutChecksum.replaceAll("-", ""));
    }
}

