/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavgoltjajev.personalcode.locale.uae;

import com.github.vladislavgoltjajev.personalcode.utility.ChecksumUtils;

public class EmiratiPersonalCodeValidator {
    public boolean isValid(String personalCode) {
        if (!this.isValidFormat(personalCode)) {
            return false;
        }
        int checksum = Character.getNumericValue(personalCode.charAt(personalCode.length() - 1));
        return checksum == ChecksumUtils.getLuhnChecksum(personalCode.replaceAll("-", "").substring(0, 14));
    }

    public boolean isValidFormat(String personalCode) {
        return personalCode != null && !personalCode.isBlank() && personalCode.matches("^784-\\d{4}-\\d{7}-\\d$");
    }
}

