/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public abstract class XsdAbstractElement {
    protected Map<String, String> elementFieldsMap = new HashMap<String, String>();
    static final String ATTRIBUTE_FORM_DEFAULT = "attribtueFormDefault";
    static final String ELEMENT_FORM_DEFAULT = "elementFormDefault";
    static final String BLOCK_DEFAULT = "blockDefault";
    static final String FINAL_DEFAULT = "finalDefault";
    static final String TARGET_NAMESPACE = "targetNamespace";
    static final String VERSION = "version";
    static final String XMLNS = "xmlns";
    static final String ID_TAG = "id";
    public static final String NAME_TAG = "name";
    static final String ABSTRACT_TAG = "abstract";
    static final String DEFAULT_ELEMENT_TAG = "defaultElement";
    protected static final String FIXED_TAG = "fixed";
    static final String TYPE_TAG = "type";
    static final String MIXED_TAG = "mixed";
    static final String BLOCK_TAG = "block";
    static final String FINAL_TAG = "final";
    static final String USE_TAG = "use";
    static final String SUBSTITUTION_GROUP_TAG = "substitutionGroup";
    static final String DEFAULT_TAG = "default";
    static final String FORM_TAG = "form";
    static final String NILLABLE_TAG = "nillable";
    static final String MIN_OCCURS_TAG = "minOccurs";
    static final String MAX_OCCURS_TAG = "maxOccurs";
    static final String ITEM_TYPE_TAG = "itemType";
    static final String BASE_TAG = "base";
    static final String SOURCE_TAG = "source";
    static final String XML_LANG_TAG = "xml:lang";
    static final String MEMBER_TYPES_TAG = "memberTypes";
    static final String SCHEMA_LOCATION = "schemaLocation";
    static final String NAMESPACE = "namespace";
    public static final String REF_TAG = "ref";
    protected static final String VALUE_TAG = "value";
    XsdAbstractElement parent;
    XsdParser parser;

    protected XsdAbstractElement(@NotNull XsdParser parser, @NotNull Map<String, String> elementFieldsMapParam) {
        this.setParser(parser);
        this.setFields(elementFieldsMapParam);
    }

    public void setFields(@NotNull Map<String, String> elementFieldsMapParam) {
        this.elementFieldsMap = elementFieldsMapParam;
    }

    public Map<String, String> getElementFieldsMap() {
        return this.elementFieldsMap;
    }

    public abstract XsdAbstractElementVisitor getVisitor();

    public void validateSchemaRules() {
    }

    public void accept(XsdAbstractElementVisitor xsdAbstractElementVisitor) {
        this.setParent(xsdAbstractElementVisitor.getOwner());
    }

    public List<ReferenceBase> getElements() {
        return Collections.emptyList();
    }

    public Stream<XsdAbstractElement> getXsdElements() {
        List<ReferenceBase> elements = this.getElements();
        if (elements == null) {
            return new ArrayList().stream();
        }
        return elements.stream().filter(element -> element instanceof ConcreteElement).map(ReferenceBase::getElement);
    }

    static ReferenceBase xsdParseSkeleton(Node node, XsdAbstractElement element) {
        XsdParser parser = element.getParser();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            BiFunction<XsdParser, Node, ReferenceBase> parserFunction = XsdParser.getParseMappers().get(nodeName);
            if (parserFunction == null) continue;
            XsdAbstractElement childElement = parserFunction.apply(parser, child).getElement();
            childElement.accept(element.getVisitor());
            childElement.validateSchemaRules();
        }
        ReferenceBase wrappedElement = ReferenceBase.createFromXsd(element);
        parser.addParsedElement(wrappedElement);
        return wrappedElement;
    }

    private void setParser(XsdParser parser) {
        this.parser = parser;
    }

    public XsdParser getParser() {
        return this.parser;
    }

    protected static Map<String, String> convertNodeMap(NamedNodeMap nodeMap) {
        HashMap<String, String> attributesMapped = new HashMap<String, String>();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node node = nodeMap.item(i);
            attributesMapped.put(node.getNodeName(), node.getNodeValue());
        }
        return attributesMapped;
    }

    public void replaceUnsolvedElements(NamedConcreteElement element) {
        List<ReferenceBase> elements = this.getElements();
        if (elements != null) {
            elements.stream().filter(referenceBase -> referenceBase instanceof UnsolvedReference).map(referenceBase -> (UnsolvedReference)referenceBase).filter(unsolvedReference -> unsolvedReference.getRef().equals(element.getName())).findFirst().ifPresent(oldElement -> {
                ReferenceBase cfr_ignored_0 = elements.set(elements.indexOf(oldElement), element);
            });
        }
    }

    public XsdAbstractElement getParent() {
        return this.parent;
    }

    public void setParent(XsdAbstractElement parent) {
        this.parent = parent;
    }

    static String xsdRawContentParse(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            stringBuilder.append(child.getTextContent());
        }
        return stringBuilder.toString();
    }
}

