/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAttributeGroupVisitor;

public class XsdAttributeGroup
extends XsdNamedElements {
    public static final String XSD_TAG = "xsd:attributeGroup";
    public static final String XS_TAG = "xs:attributeGroup";
    private final XsdAttributeGroupVisitor visitor = new XsdAttributeGroupVisitor(this);
    private List<XsdAttributeGroup> attributeGroups = new ArrayList<XsdAttributeGroup>();
    private List<ReferenceBase> attributes = new ArrayList<ReferenceBase>();

    private XsdAttributeGroup(@NotNull XsdParser parser, @NotNull Map<String, String> elementFieldsMapParam) {
        super(parser, elementFieldsMapParam);
    }

    private XsdAttributeGroup(XsdAbstractElement parent, @NotNull XsdParser parser, @NotNull Map<String, String> elementFieldsMapParam) {
        super(parser, elementFieldsMapParam);
        this.setParent(parent);
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdAttributeGroupVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public List<ReferenceBase> getElements() {
        ArrayList<ReferenceBase> allAttributes = new ArrayList<ReferenceBase>();
        this.attributeGroups.forEach(attributeGroup -> allAttributes.addAll(attributeGroup.getElements()));
        allAttributes.addAll(this.attributes);
        return allAttributes;
    }

    @Override
    public XsdNamedElements clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.elementFieldsMap);
        placeHolderAttributes.remove("ref");
        XsdAttributeGroup elementCopy = new XsdAttributeGroup(this.parent, this.parser, placeHolderAttributes);
        elementCopy.attributes.addAll(this.attributes);
        elementCopy.attributeGroups.addAll(this.attributeGroups);
        return elementCopy;
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement element) {
        if (element.getElement() instanceof XsdAttributeGroup) {
            XsdAttributeGroup attributeGroup = (XsdAttributeGroup)element.getElement();
            attributeGroup.attributes.forEach(attribute -> attribute.getElement().setParent(attributeGroup));
            this.attributeGroups.add(attributeGroup);
        }
    }

    public List<XsdAttributeGroup> getAttributeGroups() {
        return this.attributeGroups;
    }

    public Stream<XsdAttribute> getAllAttributes() {
        return this.getElements().stream().filter(element -> element.getElement() instanceof XsdAttribute).map(element -> (XsdAttribute)element.getElement());
    }

    public Stream<XsdAttribute> getDirectAttributes() {
        return this.attributes.stream().filter(element -> element.getElement() instanceof XsdAttribute).map(element -> (XsdAttribute)element.getElement());
    }

    public static ReferenceBase parse(@NotNull XsdParser parser, Node node) {
        return XsdAttributeGroup.xsdParseSkeleton(node, new XsdAttributeGroup(parser, XsdAttributeGroup.convertNodeMap(node.getAttributes())));
    }

    public void addAttribute(ReferenceBase attribute) {
        this.attributes.add(attribute);
    }
}

