/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAll;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;

public abstract class XsdMultipleElements
extends XsdAnnotatedElements {
    private List<ReferenceBase> elements = new ArrayList<ReferenceBase>();

    XsdMultipleElements(@NotNull XsdParser parser, @NotNull Map<String, String> elementFieldsMapParam) {
        super(parser, elementFieldsMapParam);
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement elementWrapper) {
        if (elementWrapper.getElement() instanceof XsdElement) {
            super.replaceUnsolvedElements(elementWrapper);
        }
        if (elementWrapper.getElement() instanceof XsdGroup) {
            this.elements.add(elementWrapper);
            this.elements.removeIf(element -> element instanceof UnsolvedReference && ((UnsolvedReference)element).getRef().equals(elementWrapper.getName()));
        }
    }

    @Override
    public List<ReferenceBase> getElements() {
        return this.elements;
    }

    @Override
    public Stream<XsdAbstractElement> getXsdElements() {
        return this.elements.stream().filter(element -> element instanceof ConcreteElement).map(ReferenceBase::getElement);
    }

    public void addElement(XsdAbstractElement element) {
        this.elements.add(ReferenceBase.createFromXsd(element));
    }

    public static XsdAll getChildAsdAll(XsdMultipleElements element) {
        return element instanceof XsdAll ? (XsdAll)element : null;
    }

    public static XsdChoice getChildAsChoice(XsdMultipleElements element) {
        return element instanceof XsdChoice ? (XsdChoice)element : null;
    }

    public static XsdSequence getChildAsSequence(XsdMultipleElements element) {
        return element instanceof XsdSequence ? (XsdSequence)element : null;
    }
}

