/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Table level detail on the usage of metadata caching. Only set for Metadata caching eligible
 * tables referenced in the query.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableMetadataCacheUsage extends com.google.api.client.json.GenericJson {

  /**
   * Free form human-readable reason metadata caching was unused for the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String explanation;

  /**
   * The column metadata index pruning statistics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PruningStats pruningStats;

  /**
   * Duration since last refresh as of this job for managed tables (indicates metadata cache
   * staleness as seen by this job).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String staleness;

  /**
   * Metadata caching eligible table referenced in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference tableReference;

  /**
   * [Table
   * type](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#Table.FIELDS.type).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tableType;

  /**
   * Reason for not using metadata caching for the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unusedReason;

  /**
   * Free form human-readable reason metadata caching was unused for the job.
   * @return value or {@code null} for none
   */
  public java.lang.String getExplanation() {
    return explanation;
  }

  /**
   * Free form human-readable reason metadata caching was unused for the job.
   * @param explanation explanation or {@code null} for none
   */
  public TableMetadataCacheUsage setExplanation(java.lang.String explanation) {
    this.explanation = explanation;
    return this;
  }

  /**
   * The column metadata index pruning statistics.
   * @return value or {@code null} for none
   */
  public PruningStats getPruningStats() {
    return pruningStats;
  }

  /**
   * The column metadata index pruning statistics.
   * @param pruningStats pruningStats or {@code null} for none
   */
  public TableMetadataCacheUsage setPruningStats(PruningStats pruningStats) {
    this.pruningStats = pruningStats;
    return this;
  }

  /**
   * Duration since last refresh as of this job for managed tables (indicates metadata cache
   * staleness as seen by this job).
   * @return value or {@code null} for none
   */
  public String getStaleness() {
    return staleness;
  }

  /**
   * Duration since last refresh as of this job for managed tables (indicates metadata cache
   * staleness as seen by this job).
   * @param staleness staleness or {@code null} for none
   */
  public TableMetadataCacheUsage setStaleness(String staleness) {
    this.staleness = staleness;
    return this;
  }

  /**
   * Metadata caching eligible table referenced in the query.
   * @return value or {@code null} for none
   */
  public TableReference getTableReference() {
    return tableReference;
  }

  /**
   * Metadata caching eligible table referenced in the query.
   * @param tableReference tableReference or {@code null} for none
   */
  public TableMetadataCacheUsage setTableReference(TableReference tableReference) {
    this.tableReference = tableReference;
    return this;
  }

  /**
   * [Table
   * type](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#Table.FIELDS.type).
   * @return value or {@code null} for none
   */
  public java.lang.String getTableType() {
    return tableType;
  }

  /**
   * [Table
   * type](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#Table.FIELDS.type).
   * @param tableType tableType or {@code null} for none
   */
  public TableMetadataCacheUsage setTableType(java.lang.String tableType) {
    this.tableType = tableType;
    return this;
  }

  /**
   * Reason for not using metadata caching for the table.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnusedReason() {
    return unusedReason;
  }

  /**
   * Reason for not using metadata caching for the table.
   * @param unusedReason unusedReason or {@code null} for none
   */
  public TableMetadataCacheUsage setUnusedReason(java.lang.String unusedReason) {
    this.unusedReason = unusedReason;
    return this;
  }

  @Override
  public TableMetadataCacheUsage set(String fieldName, Object value) {
    return (TableMetadataCacheUsage) super.set(fieldName, value);
  }

  @Override
  public TableMetadataCacheUsage clone() {
    return (TableMetadataCacheUsage) super.clone();
  }

}
