/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TimePartitioning.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TimePartitioning extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Number of milliseconds for which to keep the storage for a partition. A wrapper is
   * used here because 0 is an invalid value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expirationMs;

  /**
   * Optional. If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the
   * table is partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its
   * mode must be NULLABLE or REQUIRED. A wrapper is used here because an empty string is an invalid
   * value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String field;

  /**
   * If set to true, queries over this table require a partition filter that can be used for
   * partition elimination to be specified. This field is deprecated; please set the field with the
   * same name on the table itself instead. This field needs a wrapper because we want to output the
   * default value, false, if the user explicitly set it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean requirePartitionFilter;

  /**
   * Required. The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition
   * per day, hour, month, and year, respectively.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Optional. Number of milliseconds for which to keep the storage for a partition. A wrapper is
   * used here because 0 is an invalid value.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpirationMs() {
    return expirationMs;
  }

  /**
   * Optional. Number of milliseconds for which to keep the storage for a partition. A wrapper is
   * used here because 0 is an invalid value.
   * @param expirationMs expirationMs or {@code null} for none
   */
  public TimePartitioning setExpirationMs(java.lang.Long expirationMs) {
    this.expirationMs = expirationMs;
    return this;
  }

  /**
   * Optional. If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the
   * table is partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its
   * mode must be NULLABLE or REQUIRED. A wrapper is used here because an empty string is an invalid
   * value.
   * @return value or {@code null} for none
   */
  public java.lang.String getField() {
    return field;
  }

  /**
   * Optional. If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the
   * table is partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its
   * mode must be NULLABLE or REQUIRED. A wrapper is used here because an empty string is an invalid
   * value.
   * @param field field or {@code null} for none
   */
  public TimePartitioning setField(java.lang.String field) {
    this.field = field;
    return this;
  }

  /**
   * If set to true, queries over this table require a partition filter that can be used for
   * partition elimination to be specified. This field is deprecated; please set the field with the
   * same name on the table itself instead. This field needs a wrapper because we want to output the
   * default value, false, if the user explicitly set it.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRequirePartitionFilter() {
    return requirePartitionFilter;
  }

  /**
   * If set to true, queries over this table require a partition filter that can be used for
   * partition elimination to be specified. This field is deprecated; please set the field with the
   * same name on the table itself instead. This field needs a wrapper because we want to output the
   * default value, false, if the user explicitly set it.
   * @param requirePartitionFilter requirePartitionFilter or {@code null} for none
   */
  public TimePartitioning setRequirePartitionFilter(java.lang.Boolean requirePartitionFilter) {
    this.requirePartitionFilter = requirePartitionFilter;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * If set to true, queries over this table require a partition filter that can be used for partition
 elimination to be specified. This field is deprecated; please set the field with the same name on
 the table itself instead. This field needs a wrapper because we want to output the default value,
 false, if the user explicitly set it.
   * </p>
   */
  public boolean isRequirePartitionFilter() {
    if (requirePartitionFilter == null || requirePartitionFilter == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return requirePartitionFilter;
  }

  /**
   * Required. The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition
   * per day, hour, month, and year, respectively.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required. The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition
   * per day, hour, month, and year, respectively.
   * @param type type or {@code null} for none
   */
  public TimePartitioning setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public TimePartitioning set(String fieldName, Object value) {
    return (TimePartitioning) super.set(fieldName, value);
  }

  @Override
  public TimePartitioning clone() {
    return (TimePartitioning) super.clone();
  }

}
