/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableCollection;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public final class DependencyRequestFormatter
extends Formatter<DependencyRequest> {
    private final XProcessingEnv processingEnv;

    @Inject
    DependencyRequestFormatter(XProcessingEnv processingEnv) {
        this.processingEnv = processingEnv;
    }

    public String formatEdges(ImmutableCollection<BindingGraph.DependencyEdge> edges, BindingGraph graph) {
        return edges.stream().map(edge -> this.formatEdge((BindingGraph.DependencyEdge)edge, graph)).filter(line -> !line.isEmpty()).collect(Collectors.joining("\n"));
    }

    public String formatEdge(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        BindingGraph.Node sourceNode = (BindingGraph.Node)graph.network().incidentNodes((Object)edge).source();
        XTypeElement sourceComponent = sourceNode.componentPath().currentComponent().xprocessing();
        return this.format(Optional.of(sourceComponent), edge.dependencyRequest());
    }

    @Override
    public String format(DependencyRequest request) {
        return this.format(Optional.empty(), request);
    }

    private String format(Optional<XTypeElement> optionalComponent, DependencyRequest request) {
        if (!request.requestElement().isPresent()) {
            return "";
        }
        XElement requestElement = request.requestElement().get().xprocessing();
        String componentReference = optionalComponent.map(component -> String.format("[%s] ", component.getQualifiedName())).orElse("");
        if (XElementKt.isMethod(requestElement)) {
            return "    " + request.key() + " is " + DependencyRequestFormatter.componentMethodRequestVerb(request) + " at\n" + "        " + componentReference + ElementFormatter.elementToString(requestElement);
        }
        if (XElementKt.isVariableElement(requestElement)) {
            return "    " + DependencyRequestFormatter.formatQualifier(request.key().qualifier()) + XTypes.toStableString(RequestKinds.requestType(request.kind(), request.key().type().xprocessing(), this.processingEnv)) + " is injected at\n" + "        " + componentReference + ElementFormatter.elementToString(requestElement);
        }
        if (XElementKt.isTypeElement(requestElement)) {
            return "";
        }
        throw new IllegalStateException("Invalid request element " + requestElement);
    }

    private static String formatQualifier(Optional<DaggerAnnotation> maybeQualifier) {
        return maybeQualifier.map(qualifier -> qualifier + " ").orElse("");
    }

    private static String componentMethodRequestVerb(DependencyRequest request) {
        switch (request.kind()) {
            case FUTURE: 
            case PRODUCER: 
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: 
            case PROVIDER_OF_LAZY: {
                return "requested";
            }
            case MEMBERS_INJECTION: {
                return "injected";
            }
        }
        throw new AssertionError((Object)("illegal request kind for method: " + request));
    }
}

