/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import dagger.internal.codegen.compileroption.ProcessingOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.validation.DiagnosticReporterFactory;
import dagger.internal.codegen.validation.External;
import dagger.internal.codegen.validation.ModelBindingGraphConverter;
import dagger.internal.codegen.validation.SpiModelBindingGraphConverter;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.model.BindingGraph;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.tools.Diagnostic;

public final class ExternalBindingGraphPlugins {
    private final ImmutableSet<BindingGraphPlugin> legacyPlugins;
    private final ImmutableSet<dagger.spi.model.BindingGraphPlugin> plugins;
    private final DiagnosticReporterFactory diagnosticReporterFactory;
    private final XFiler filer;
    private final XProcessingEnv processingEnv;
    private final Map<String, String> processingOptions;

    @Inject
    ExternalBindingGraphPlugins(@External ImmutableSet<BindingGraphPlugin> legacyPlugins, @External ImmutableSet<dagger.spi.model.BindingGraphPlugin> plugins, DiagnosticReporterFactory diagnosticReporterFactory, XFiler filer, XProcessingEnv processingEnv, @ProcessingOptions Map<String, String> processingOptions) {
        this.legacyPlugins = legacyPlugins;
        this.plugins = plugins;
        this.diagnosticReporterFactory = diagnosticReporterFactory;
        this.filer = filer;
        this.processingEnv = processingEnv;
        this.processingOptions = processingOptions;
    }

    public ImmutableSet<String> allSupportedOptions() {
        return (ImmutableSet)Stream.concat(this.legacyPlugins.stream().flatMap(plugin -> plugin.supportedOptions().stream()), this.plugins.stream().flatMap(plugin -> plugin.supportedOptions().stream())).collect(DaggerStreams.toImmutableSet());
    }

    public void initializePlugins() {
        this.plugins.forEach(this::initializePlugin);
        this.legacyPlugins.forEach(this::initializeLegacyPlugin);
    }

    private void initializePlugin(dagger.spi.model.BindingGraphPlugin plugin) {
        Set supportedOptions = plugin.supportedOptions();
        ImmutableMap filteredOptions = supportedOptions.isEmpty() ? ImmutableMap.of() : Maps.filterKeys(this.processingOptions, supportedOptions::contains);
        plugin.init(SpiModelBindingGraphConverter.toSpiModel(this.processingEnv), (Map)filteredOptions);
    }

    public void onProcessingRoundBegin() {
        this.plugins.forEach(dagger.spi.model.BindingGraphPlugin::onProcessingRoundBegin);
    }

    private void initializeLegacyPlugin(BindingGraphPlugin plugin) {
        plugin.initFiler(XConverters.toJavac(this.filer));
        plugin.initTypes(XConverters.toJavac(this.processingEnv).getTypeUtils());
        plugin.initElements(XConverters.toJavac(this.processingEnv).getElementUtils());
        Set supportedOptions = plugin.supportedOptions();
        if (!supportedOptions.isEmpty()) {
            plugin.initOptions(Maps.filterKeys(this.processingOptions, supportedOptions::contains));
        }
    }

    boolean visit(dagger.internal.codegen.model.BindingGraph graph) {
        return this.visitLegacyPlugins(graph) && this.visitPlugins(graph);
    }

    private boolean visitLegacyPlugins(dagger.internal.codegen.model.BindingGraph graph) {
        if (this.legacyPlugins.isEmpty()) {
            return true;
        }
        dagger.model.BindingGraph legacyGraph = ModelBindingGraphConverter.toModel(graph);
        boolean isClean = true;
        for (BindingGraphPlugin legacyPlugin : this.legacyPlugins) {
            DiagnosticReporterFactory.DiagnosticReporterImpl reporter = this.diagnosticReporterFactory.reporter(graph, legacyPlugin.pluginName());
            DiagnosticReporter legacyReporter = ModelBindingGraphConverter.toModel(reporter);
            legacyPlugin.visitGraph(legacyGraph, legacyReporter);
            if (!reporter.reportedDiagnosticKinds().contains((Object)Diagnostic.Kind.ERROR)) continue;
            isClean = false;
        }
        return isClean;
    }

    private boolean visitPlugins(dagger.internal.codegen.model.BindingGraph graph) {
        BindingGraph spiGraph = SpiModelBindingGraphConverter.toSpiModel(graph, this.processingEnv);
        boolean isClean = true;
        for (dagger.spi.model.BindingGraphPlugin plugin : this.plugins) {
            DiagnosticReporterFactory.DiagnosticReporterImpl reporter = this.diagnosticReporterFactory.reporter(graph, plugin.pluginName());
            plugin.visitGraph(spiGraph, SpiModelBindingGraphConverter.toSpiModel(reporter));
            if (!reporter.reportedDiagnosticKinds().contains((Object)Diagnostic.Kind.ERROR)) continue;
            isClean = false;
        }
        return isClean;
    }

    public void endPlugins() {
        this.legacyPlugins.forEach(BindingGraphPlugin::onPluginEnd);
        this.plugins.forEach(dagger.spi.model.BindingGraphPlugin::onPluginEnd);
    }
}

