/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.profiles;

import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.storage.IntsRef;
import java.util.Locale;
import java.util.Objects;

public class UnsignedIntEncodedValue
implements IntEncodedValue {
    private final String name;
    protected int fwdDataIndex;
    protected int bwdDataIndex;
    final int bits;
    int maxValue;
    int fwdShift = -1;
    int bwdShift = -1;
    int fwdMask;
    int bwdMask;
    boolean storeTwoDirections;

    public UnsignedIntEncodedValue(String name, int bits, boolean storeTwoDirections) {
        if (!name.toLowerCase(Locale.ROOT).equals(name)) {
            throw new IllegalArgumentException("EncodedValue name must be lower case but was " + name);
        }
        if (bits <= 0) {
            throw new IllegalArgumentException(name + ": bits cannot be zero or negative");
        }
        if (bits > 31) {
            throw new IllegalArgumentException(name + ": at the moment the number of reserved bits cannot be more than 31");
        }
        this.bits = bits;
        this.name = name;
        this.storeTwoDirections = storeTwoDirections;
    }

    @Override
    public final int init(EncodedValue.InitializerConfig init) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot call init multiple times");
        }
        init.next(this.bits);
        this.fwdMask = init.bitMask;
        this.fwdDataIndex = init.dataIndex;
        this.fwdShift = init.shift;
        if (this.storeTwoDirections) {
            init.next(this.bits);
            this.bwdMask = init.bitMask;
            this.bwdDataIndex = init.dataIndex;
            this.bwdShift = init.shift;
        }
        this.maxValue = (1 << this.bits) - 1;
        return this.storeTwoDirections ? 2 * this.bits : this.bits;
    }

    boolean isInitialized() {
        return this.fwdMask != 0;
    }

    private void checkValue(int value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("EncodedValue " + this.getName() + " not initialized");
        }
        if (value > this.maxValue) {
            throw new IllegalArgumentException(this.name + " value too large for encoding: " + value + ", maxValue:" + this.maxValue);
        }
        if (value < 0) {
            throw new IllegalArgumentException("negative value for " + this.name + " not allowed! " + value);
        }
    }

    @Override
    public final void setInt(boolean reverse, IntsRef ref, int value) {
        this.checkValue(value);
        this.uncheckedSet(reverse, ref, value);
    }

    final void uncheckedSet(boolean reverse, IntsRef ref, int value) {
        if (reverse && !this.storeTwoDirections) {
            throw new IllegalArgumentException(this.getName() + ": value for reverse direction would overwrite forward direction. Enable storeTwoDirections for this EncodedValue or don't use setReverse");
        }
        if (reverse) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            ref.ints[this.bwdDataIndex + ref.offset] = (flags &= ~this.bwdMask) | (value <<= this.bwdShift);
        } else {
            int flags = ref.ints[this.fwdDataIndex + ref.offset];
            ref.ints[this.fwdDataIndex + ref.offset] = (flags &= ~this.fwdMask) | (value <<= this.fwdShift);
        }
    }

    @Override
    public final int getInt(boolean reverse, IntsRef ref) {
        if (reverse && this.storeTwoDirections) {
            int flags = ref.ints[this.bwdDataIndex + ref.offset];
            return (flags & this.bwdMask) >>> this.bwdShift;
        }
        int flags = ref.ints[this.fwdDataIndex + ref.offset];
        return (flags & this.fwdMask) >>> this.fwdShift;
    }

    @Override
    public int getMaxInt() {
        return this.maxValue;
    }

    @Override
    public final boolean isStoreTwoDirections() {
        return this.storeTwoDirections;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.getName() + "|version=" + this.getVersion() + "|bits=" + this.bits + "|index=" + this.fwdDataIndex + "|shift=" + this.fwdShift + "|store_both_directions=" + this.storeTwoDirections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedIntEncodedValue that = (UnsignedIntEncodedValue)o;
        return this.fwdDataIndex == that.fwdDataIndex && this.bwdDataIndex == that.bwdDataIndex && this.bits == that.bits && this.maxValue == that.maxValue && this.fwdShift == that.fwdShift && this.bwdShift == that.bwdShift && this.fwdMask == that.fwdMask && this.bwdMask == that.bwdMask && this.storeTwoDirections == that.storeTwoDirections && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fwdDataIndex, this.bwdDataIndex, this.bits, this.maxValue, this.fwdShift, this.bwdShift, this.fwdMask, this.bwdMask, this.storeTwoDirections);
    }

    @Override
    public int getVersion() {
        return this.hashCode();
    }
}

