/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueFactory;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.DefaultFlagEncoderFactory;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.parsers.OSMRoundaboutParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class EncodingManager
implements EncodedValueLookup {
    private static final String ERR = "Encoders are requesting %s bits, more than %s bits of %s flags. ";
    private final List<AbstractFlagEncoder> edgeEncoders = new ArrayList<AbstractFlagEncoder>();
    private final Map<String, EncodedValue> encodedValueMap = new LinkedHashMap<String, EncodedValue>();
    private final List<TagParser> tagParserList = new ArrayList<TagParser>();
    private final int bitsForEdgeFlags;
    private final int bitsForTurnFlags = 32;
    private int nextNodeBit = 0;
    private int nextRelBit = 0;
    private int nextTurnBit = 0;
    private boolean enableInstructions = true;
    private String preferredLanguage = "";
    private EncodedValue.InitializerConfig config;
    private static String SPECIAL_SEPARATOR = "-";

    public static EncodingManager create(String flagEncodersStr) {
        return EncodingManager.create(flagEncodersStr, 4);
    }

    public static EncodingManager create(String flagEncodersStr, int bytesForEdgeFlags) {
        return EncodingManager.create(new DefaultFlagEncoderFactory(), flagEncodersStr, bytesForEdgeFlags);
    }

    public static EncodingManager create(FlagEncoderFactory factory, String flagEncodersStr, int bytesForEdgeFlags) {
        return EncodingManager.createBuilder(factory, flagEncodersStr, bytesForEdgeFlags).build();
    }

    public static Builder createBuilder(FlagEncoderFactory factory, String flagEncodersStr, int bytesForEdgeFlags) {
        return EncodingManager.createBuilder(EncodingManager.parseEncoderString(factory, flagEncodersStr), bytesForEdgeFlags);
    }

    public static EncodingManager create(FlagEncoder ... flagEncoders) {
        return EncodingManager.create(Arrays.asList(flagEncoders));
    }

    public static EncodingManager create(List<? extends FlagEncoder> flagEncoders) {
        return EncodingManager.create(flagEncoders, 4);
    }

    public static EncodingManager create(List<? extends FlagEncoder> flagEncoders, int bytesForEdgeFlags) {
        return EncodingManager.createBuilder(flagEncoders, bytesForEdgeFlags).build();
    }

    private static Builder createBuilder(List<? extends FlagEncoder> flagEncoders, int bytesForEdgeFlags) {
        Builder builder = new Builder(bytesForEdgeFlags);
        for (FlagEncoder flagEncoder : flagEncoders) {
            builder.add(flagEncoder);
        }
        return builder;
    }

    public static EncodingManager create(EncodedValueFactory evFactory, FlagEncoderFactory flagEncoderFactory, String ghLoc) {
        String flagEncoderValuesStr;
        RAMDirectory dir = new RAMDirectory(ghLoc, true);
        StorableProperties properties = new StorableProperties(dir);
        if (!properties.loadExisting()) {
            throw new IllegalStateException("Cannot load properties to fetch EncodingManager configuration at: " + dir.getLocation());
        }
        properties.checkVersions(false);
        int bytesForFlags = 4;
        try {
            bytesForFlags = Integer.parseInt(properties.get("graph.bytes_for_flags"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Builder builder = new Builder(bytesForFlags, false);
        String encodedValuesStr = properties.get("graph.encoded_values");
        if (!Helper.isEmpty((String)encodedValuesStr)) {
            builder.addAll(evFactory, encodedValuesStr);
        }
        if (!Helper.isEmpty((String)(flagEncoderValuesStr = properties.get("graph.flag_encoders")))) {
            builder.addAll(flagEncoderFactory, flagEncoderValuesStr);
        }
        if (Helper.isEmpty((String)flagEncoderValuesStr) && Helper.isEmpty((String)encodedValuesStr)) {
            throw new IllegalStateException("EncodingManager was not configured. And no one was found in the graph: " + dir.getLocation());
        }
        return builder.build();
    }

    public static Builder start() {
        return new Builder(4);
    }

    private EncodingManager(int bytes) {
        if (bytes <= 0 || bytes / 4 * 4 != bytes) {
            throw new IllegalStateException("bytesForEdgeFlags can be only a multiple of 4");
        }
        this.bitsForEdgeFlags = bytes * 8;
        this.config = new EncodedValue.InitializerConfig();
    }

    static List<FlagEncoder> parseEncoderString(FlagEncoderFactory factory, String encoderList) {
        if (encoderList.contains(":")) {
            throw new IllegalArgumentException("EncodingManager does no longer use reflection instantiate encoders directly.");
        }
        if (!encoderList.equals(Helper.toLowerCase((String)encoderList))) {
            throw new IllegalArgumentException("Since 0.7 EncodingManager does no longer accept upper case profiles: " + encoderList);
        }
        String[] entries = encoderList.split(",");
        ArrayList<FlagEncoder> resultEncoders = new ArrayList<FlagEncoder>();
        for (String entry : entries) {
            if ((entry = Helper.toLowerCase((String)entry.trim())).isEmpty()) continue;
            String entryVal = "";
            if (entry.contains("|")) {
                entryVal = entry;
                entry = entry.split("\\|")[0];
            }
            PMap configuration = new PMap(entryVal);
            FlagEncoder fe = factory.createFlagEncoder(entry, configuration);
            if (configuration.has("version") && fe.getVersion() != configuration.getInt("version", -1)) {
                throw new IllegalArgumentException("Encoder " + entry + " was used in version " + configuration.getLong("version", -1L) + ", but current version is " + fe.getVersion());
            }
            resultEncoders.add(fe);
        }
        return resultEncoders;
    }

    private void add(Builder builder, EncodedValueFactory factory, String evList) {
        if (!evList.equals(Helper.toLowerCase((String)evList))) {
            throw new IllegalArgumentException("Use lower case for EncodedValues: " + evList);
        }
        for (String entry : evList.split(",")) {
            if ((entry = Helper.toLowerCase((String)entry.trim())).isEmpty()) continue;
            EncodedValue evObject = factory.create(entry);
            builder.add(evObject);
            PMap map = new PMap(entry);
            if (!map.has("version")) {
                throw new IllegalArgumentException("encoded value must have a version specified but it was " + entry);
            }
            int version = map.getInt("version", Integer.MIN_VALUE);
            int stored = evObject.getVersion();
            if (stored == version) continue;
            throw new IllegalArgumentException("Version of EncodedValue " + evObject + " does not match " + entry + ". Stored " + stored + " vs. in code " + version);
        }
    }

    private void add(Builder builder, TagParserFactory factory, String tpList) {
        if (!tpList.equals(Helper.toLowerCase((String)tpList))) {
            throw new IllegalArgumentException("Use lower case for TagParser: " + tpList);
        }
        for (String entry : tpList.split(",")) {
            if ((entry = entry.trim()).isEmpty()) continue;
            PMap map = new PMap(entry);
            TagParser tp = factory.create(entry, map);
            builder.add(tp);
        }
    }

    static String fixWayName(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll(";[ ]*", ", ");
    }

    public int getBytesForFlags() {
        return this.bitsForEdgeFlags / 8;
    }

    private void setEnableInstructions(boolean enableInstructions) {
        this.enableInstructions = enableInstructions;
    }

    public boolean isEnableInstructions() {
        return this.enableInstructions;
    }

    private void setPreferredLanguage(String preferredLanguage) {
        if (preferredLanguage == null) {
            throw new IllegalArgumentException("preferred language cannot be null");
        }
        this.preferredLanguage = preferredLanguage;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    private void addEncoder(AbstractFlagEncoder encoder) {
        if (encoder.isRegistered()) {
            throw new IllegalStateException("You must not register a FlagEncoder (" + encoder.toString() + ") twice!");
        }
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.toString().equals(encoder.toString())) continue;
            throw new IllegalArgumentException("Cannot register edge encoder. Name already exists: " + flagEncoder.toString());
        }
        encoder.setRegistered(true);
        int encoderCount = this.edgeEncoders.size();
        int n = encoder.defineNodeBits(encoderCount, this.nextNodeBit);
        if (n > this.bitsForEdgeFlags) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n, this.bitsForEdgeFlags, "node"));
        }
        encoder.setNodeBitMask(n - this.nextNodeBit, this.nextNodeBit);
        this.nextNodeBit = n;
        encoder.setEncodedValueLookup(this);
        ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
        encoder.createEncodedValues(list, encoder.toString(), encoderCount);
        for (EncodedValue ev : list) {
            this.addEncodedValue(ev, true);
        }
        int n2 = encoder.defineRelationBits(encoderCount, this.nextRelBit);
        if (n2 > this.bitsForEdgeFlags) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n2, this.bitsForEdgeFlags, "relation"));
        }
        encoder.setRelBitMask(n2 - this.nextRelBit, this.nextRelBit);
        this.nextRelBit = n2;
        int n3 = encoder.defineTurnBits(encoderCount, this.nextTurnBit);
        if (n3 > 32) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n3, 32, "turn"));
        }
        this.nextTurnBit = n3;
        this.edgeEncoders.add(encoder);
    }

    private void addEncodedValue(EncodedValue ev, boolean encValBoundToFlagEncoder) {
        if (this.encodedValueMap.containsKey(ev.getName())) {
            throw new IllegalStateException("EncodedValue " + ev.getName() + " already exists " + this.encodedValueMap.get(ev.getName()) + " vs " + ev);
        }
        if (!encValBoundToFlagEncoder && ev.getName().contains(SPECIAL_SEPARATOR)) {
            throw new IllegalArgumentException("EncodedValue " + ev.getName() + " must not contain '" + SPECIAL_SEPARATOR + "' as reserved for FlagEncoder");
        }
        ev.init(this.config);
        if (this.config.getRequiredBits() > this.getBytesForFlags() * 8) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Encoders are requesting %s bits, more than %s bits of %s flags. (Attempt to add EncodedValue " + ev.getName() + ") ", this.config.getRequiredBits(), this.bitsForEdgeFlags, "edge") + "Decrease the number of vehicles or increase the flags to more bytes via graph.bytes_for_flags: " + (this.config.getRequiredBits() / 32 * 4 + 4));
        }
        this.encodedValueMap.put(ev.getName(), ev);
    }

    @Override
    public boolean hasEncodedValue(String key) {
        return this.encodedValueMap.get(key) != null;
    }

    public boolean hasEncoder(String encoder) {
        return this.getEncoder(encoder, false) != null;
    }

    public FlagEncoder getEncoder(String name) {
        return this.getEncoder(name, true);
    }

    private FlagEncoder getEncoder(String name, boolean throwExc) {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!name.equalsIgnoreCase(flagEncoder.toString())) continue;
            return flagEncoder;
        }
        if (throwExc) {
            throw new IllegalArgumentException("Encoder for " + name + " not found. Existing: " + this.toFlagEncodersAsString());
        }
        return null;
    }

    public boolean acceptWay(ReaderWay way, AcceptWay acceptWay) {
        if (!acceptWay.isEmpty()) {
            throw new IllegalArgumentException("AcceptWay must be empty");
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            acceptWay.put(encoder.toString(), encoder.getAccess(way));
        }
        return acceptWay.hasAccepted();
    }

    public long handleRelationTags(long oldRelationFlags, ReaderRelation relation) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.handleRelationTags(oldRelationFlags, relation);
        }
        return flags;
    }

    public IntsRef handleWayTags(ReaderWay way, AcceptWay acceptWay, long relationFlags) {
        IntsRef edgeFlags = this.createEdgeFlags();
        Access access = acceptWay.getAccess();
        for (TagParser parser : this.tagParserList) {
            parser.handleWayTags(edgeFlags, way, access, relationFlags);
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.handleWayTags(edgeFlags, way, acceptWay.get(encoder.toString()), relationFlags & encoder.getRelBitMask());
        }
        return edgeFlags;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(flagEncoder.toString());
        }
        return str.toString();
    }

    public String toFlagEncodersAsString() {
        StringBuilder str = new StringBuilder();
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(encoder.toString()).append("|").append(encoder.getPropertiesString()).append("|version=").append(encoder.getVersion());
        }
        return str.toString();
    }

    public String toEncodedValuesAsString() {
        StringBuilder str = new StringBuilder();
        for (EncodedValue ev : this.encodedValueMap.values()) {
            if (ev.getName().contains(SPECIAL_SEPARATOR)) continue;
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(ev.toString());
        }
        return str.toString();
    }

    public IntsRef createEdgeFlags() {
        return new IntsRef(this.bitsForEdgeFlags / 32);
    }

    public IntsRef flagsDefault(boolean forward, boolean backward) {
        IntsRef intsRef = this.createEdgeFlags();
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.flagsDefault(intsRef, forward, backward);
        }
        return intsRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingManager that = (EncodingManager)o;
        return this.bitsForEdgeFlags == that.bitsForEdgeFlags && this.enableInstructions == that.enableInstructions && this.edgeEncoders.equals(that.edgeEncoders) && this.encodedValueMap.equals(that.encodedValueMap) && this.preferredLanguage.equals(that.preferredLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.edgeEncoders, this.encodedValueMap, this.bitsForEdgeFlags, this.enableInstructions, this.preferredLanguage);
    }

    public long handleNodeTags(ReaderNode node) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.handleNodeTags(node);
        }
        return flags;
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        if (this.enableInstructions) {
            String refName;
            String name = "";
            if (!this.preferredLanguage.isEmpty()) {
                name = EncodingManager.fixWayName(way.getTag("name:" + this.preferredLanguage));
            }
            if (name.isEmpty()) {
                name = EncodingManager.fixWayName(way.getTag("name"));
            }
            if (!(refName = EncodingManager.fixWayName(way.getTag("ref"))).isEmpty()) {
                name = name.isEmpty() ? refName : name + ", " + refName;
            }
            edge.setName(name);
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.applyWayTags(way, edge);
        }
    }

    public List<FlagEncoder> fetchEdgeEncoders() {
        return new ArrayList<FlagEncoder>(this.edgeEncoders);
    }

    public boolean needsTurnCostsSupport() {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.supports(TurnWeighting.class)) continue;
            return true;
        }
        return false;
    }

    public List<BooleanEncodedValue> getAccessEncFromNodeFlags(long importNodeFlags) {
        ArrayList<BooleanEncodedValue> list = new ArrayList<BooleanEncodedValue>(this.edgeEncoders.size());
        for (int i = 0; i < this.edgeEncoders.size(); ++i) {
            FlagEncoder encoder = this.edgeEncoders.get(i);
            if ((1L << i & importNodeFlags) == 0L) continue;
            list.add(encoder.getAccessEnc());
        }
        return list;
    }

    @Override
    public BooleanEncodedValue getBooleanEncodedValue(String key) {
        return this.getEncodedValue(key, BooleanEncodedValue.class);
    }

    @Override
    public IntEncodedValue getIntEncodedValue(String key) {
        return this.getEncodedValue(key, IntEncodedValue.class);
    }

    @Override
    public DecimalEncodedValue getDecimalEncodedValue(String key) {
        return this.getEncodedValue(key, DecimalEncodedValue.class);
    }

    @Override
    public <T extends Enum> EnumEncodedValue<T> getEnumEncodedValue(String key, Class<T> type) {
        return this.getEncodedValue(key, EnumEncodedValue.class);
    }

    @Override
    public <T extends EncodedValue> T getEncodedValue(String key, Class<T> encodedValueType) {
        EncodedValue ev = this.encodedValueMap.get(key);
        if (ev == null) {
            throw new IllegalArgumentException("Cannot find EncodedValue " + key + " in collection: " + ev);
        }
        return (T)ev;
    }

    public static String getKey(FlagEncoder encoder, String str) {
        return EncodingManager.getKey(encoder.toString(), str);
    }

    public static String getKey(String prefix, String str) {
        return prefix + SPECIAL_SEPARATOR + str;
    }

    public static enum Access {
        WAY,
        FERRY,
        OTHER,
        CAN_SKIP;


        public boolean isFerry() {
            return this.ordinal() == FERRY.ordinal();
        }

        public boolean isWay() {
            return this.ordinal() == WAY.ordinal();
        }

        public boolean isOther() {
            return this.ordinal() == OTHER.ordinal();
        }

        public boolean canSkip() {
            return this.ordinal() == CAN_SKIP.ordinal();
        }
    }

    public static class AcceptWay {
        private Map<String, Access> accessMap = new HashMap<String, Access>(5);
        boolean hasAccepted = false;

        private Access get(String key) {
            Access res = this.accessMap.get(key);
            if (res == null) {
                throw new IllegalArgumentException("Couldn't fetch Access value for encoder key " + key);
            }
            return res;
        }

        public AcceptWay put(String key, Access access) {
            this.accessMap.put(key, access);
            if (access != Access.CAN_SKIP) {
                this.hasAccepted = true;
            }
            return this;
        }

        public boolean isEmpty() {
            return this.accessMap.isEmpty();
        }

        public boolean hasAccepted() {
            return this.hasAccepted;
        }

        private boolean has(String key) {
            return this.accessMap.containsKey(key);
        }

        public Access getAccess() {
            if (this.accessMap.isEmpty()) {
                throw new IllegalStateException("Cannot determine Access if map is empty");
            }
            return this.accessMap.values().iterator().next();
        }
    }

    public static class Builder {
        private EncodingManager em;

        public Builder(int bytes) {
            this(bytes, true);
        }

        private Builder(int bytes, boolean addRoundabout) {
            this.em = new EncodingManager(bytes);
            if (addRoundabout) {
                this.add(new OSMRoundaboutParser());
            }
        }

        public Builder setPreferredLanguage(String language) {
            this.check();
            this.em.setPreferredLanguage(language);
            return this;
        }

        public Builder setEnableInstructions(boolean enable) {
            this.check();
            this.em.setEnableInstructions(enable);
            return this;
        }

        public Builder addAll(FlagEncoderFactory factory, String flagEncodersStr) {
            for (FlagEncoder fe : EncodingManager.parseEncoderString(factory, flagEncodersStr)) {
                this.add(fe);
            }
            return this;
        }

        public Builder addAll(EncodedValueFactory factory, String encodedValueString) {
            this.em.add(this, factory, encodedValueString);
            return this;
        }

        public Builder addAll(TagParserFactory factory, String tagParserString) {
            this.em.add(this, factory, tagParserString);
            return this;
        }

        public Builder add(FlagEncoder encoder) {
            this.check();
            this.em.addEncoder((AbstractFlagEncoder)encoder);
            return this;
        }

        public Builder add(EncodedValue encodedValue) {
            this.check();
            if (!this.em.edgeEncoders.isEmpty()) {
                throw new IllegalArgumentException("Always add shared EncodedValues before FlagEncoders to ensure they can be loaded first");
            }
            this.em.addEncodedValue(encodedValue, false);
            return this;
        }

        public Builder add(TagParser tagParser) {
            ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
            tagParser.createEncodedValues(this.em, list);
            for (EncodedValue ev : list) {
                this.em.addEncodedValue(ev, false);
            }
            this.em.tagParserList.add(tagParser);
            return this;
        }

        private void check() {
            if (this.em == null) {
                throw new IllegalStateException("Cannot call method after Builder.build() was called");
            }
        }

        public EncodingManager build() {
            this.check();
            if (this.em.encodedValueMap.isEmpty()) {
                throw new IllegalStateException("No EncodedValues found");
            }
            EncodingManager tmp = this.em;
            this.em = null;
            return tmp;
        }
    }
}

