/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.domain.memory.BamLocationDependentJvmMemoryLocation;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;

public interface TraceExtractor<ContentT extends AbstractState<ContentT>> {
    default public Set<List<BamLocationDependentJvmMemoryLocation<ContentT>>> extractLinearTraces() {
        HashSet<List<BamLocationDependentJvmMemoryLocation<ContentT>>> result = new HashSet<List<BamLocationDependentJvmMemoryLocation<ContentT>>>();
        for (BamLocationDependentJvmMemoryLocation<ContentT> endpoint : this.getEndPoints()) {
            ArrayList<BamLocationDependentJvmMemoryLocation<ContentT>> trace = new ArrayList<BamLocationDependentJvmMemoryLocation<ContentT>>();
            trace.add(endpoint);
            this.traceExtractionIteration(result, trace);
        }
        return result.stream().map(this::removeDuplicateProgramLocations).collect(Collectors.toSet());
    }

    public Collection<BamLocationDependentJvmMemoryLocation<ContentT>> getEndPoints();

    public ProgramLocationDependentReachedSet<JvmMemoryLocationAbstractState<ContentT>> getTraceReconstructionReachedSet();

    default public void traceExtractionIteration(Set<List<BamLocationDependentJvmMemoryLocation<ContentT>>> result, List<BamLocationDependentJvmMemoryLocation<ContentT>> currentTrace) {
        BamLocationDependentJvmMemoryLocation<ContentT> currentNode = currentTrace.get(currentTrace.size() - 1);
        ArrayList<JvmMemoryLocationAbstractState<ContentT>> currentStates = new ArrayList<JvmMemoryLocationAbstractState<ContentT>>();
        for (JvmMemoryLocationAbstractState<ContentT> jvmMemoryLocationAbstractState : this.getTraceReconstructionReachedSet().getReached(currentNode.getProgramLocation())) {
            if (!jvmMemoryLocationAbstractState.getLocationDependentMemoryLocation().equals(currentNode)) continue;
            currentStates.add(jvmMemoryLocationAbstractState);
        }
        for (JvmMemoryLocationAbstractState<Object> jvmMemoryLocationAbstractState : currentStates) {
            Set<BamLocationDependentJvmMemoryLocation<Object>> sourceLocations = jvmMemoryLocationAbstractState.getSourceLocations();
            if (sourceLocations.isEmpty()) {
                result.add(currentTrace);
            }
            for (BamLocationDependentJvmMemoryLocation<Object> location : sourceLocations) {
                if (currentTrace.contains(location)) continue;
                ArrayList<BamLocationDependentJvmMemoryLocation<ContentT>> trace = new ArrayList<BamLocationDependentJvmMemoryLocation<ContentT>>(currentTrace);
                trace.add(location);
                this.traceExtractionIteration(result, trace);
            }
        }
    }

    default public List<BamLocationDependentJvmMemoryLocation<ContentT>> removeDuplicateProgramLocations(List<BamLocationDependentJvmMemoryLocation<ContentT>> trace) {
        ArrayList<BamLocationDependentJvmMemoryLocation<ContentT>> result = new ArrayList<BamLocationDependentJvmMemoryLocation<ContentT>>();
        result.add(trace.get(0));
        for (int i = 1; i < trace.size(); ++i) {
            if (trace.get(i).getProgramLocation().getOffset() < 0 || ((BamLocationDependentJvmMemoryLocation)result.get(result.size() - 1)).getProgramLocation().getOffset() == trace.get(i).getProgramLocation().getOffset() && Objects.equals(((BamLocationDependentJvmMemoryLocation)result.get(result.size() - 1)).getProgramLocation().getSignature(), trace.get(i).getProgramLocation().getSignature())) continue;
            result.add(trace.get(i));
        }
        return result;
    }
}

