/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.Clazz;
import proguard.classfile.MethodSignature;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.executor.Executor;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.TypedReferenceValue;

final class ExecutorLookup {
    private static final Logger log = LogManager.getLogger(ExecutorLookup.class);
    private static final boolean PRINT_ERRORS = System.getProperty("proguard.value.logerrors") != null;
    private final Map<MethodSignature, Executor> executorFromSignature = new HashMap<MethodSignature, Executor>();
    private final Set<String> supportedClasses = new HashSet<String>();

    public ExecutorLookup(List<Executor> registeredExecutors) {
        for (Executor executor : registeredExecutors) {
            for (MethodSignature signature : executor.getSupportedMethodSignatures()) {
                if (PRINT_ERRORS && signature.isIncomplete()) {
                    log.warn("Wildcard signatures are not supported by ExecutorLookup, they will get ignored");
                    continue;
                }
                if (this.executorFromSignature.putIfAbsent(signature, executor) != null) {
                    if (!PRINT_ERRORS) continue;
                    log.warn("Signature {} is supported by multiple executors. {} will be ignored", (Object)signature, (Object)executor.getClass().getSimpleName());
                    continue;
                }
                this.supportedClasses.add(signature.getClassName());
            }
        }
    }

    @Nullable
    public Executor lookupExecutor(@NotNull MethodExecutionInfo info) {
        MethodSignature targetSignature;
        MethodSignature staticSignature = info.getSignature();
        boolean isTargetDynamic = false;
        if (info.isInstanceMethod() && info.getInstanceNonStatic() instanceof TypedReferenceValue && info.getInstanceNonStatic().getType() != null) {
            isTargetDynamic = true;
            TypedReferenceValue instance = (TypedReferenceValue)info.getInstanceNonStatic();
            targetSignature = new MethodSignature(ClassUtil.internalClassNameFromClassType(instance.getType()), staticSignature.method, staticSignature.descriptor);
        } else {
            targetSignature = staticSignature;
        }
        info.setResolvedTargetSignature(targetSignature);
        Executor targetExecutor = this.executorFromSignature.get(targetSignature);
        if (PRINT_ERRORS && isTargetDynamic && targetExecutor == null && this.executorFromSignature.get(staticSignature) != null) {
            log.warn("Dynamic target {} is not supported by the executors but static target {} is, check if your executor should also support the child class methods", (Object)targetSignature, (Object)staticSignature);
        }
        return targetExecutor;
    }

    public boolean hasExecutorFor(@NotNull MethodSignature methodSignature) {
        return this.executorFromSignature.containsKey(methodSignature);
    }

    public boolean shouldTrackInstancesOf(@NotNull Clazz clazz) {
        return this.shouldTrackInstancesOf(clazz.getName());
    }

    public boolean shouldTrackInstancesOf(@NotNull String className) {
        return this.supportedClasses.contains(className);
    }
}

