/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.MethodSignature;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.Executor;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.model.ClassModel;
import proguard.exception.ProguardCoreException;

public class ObjectGetClassExecutor
implements Executor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final Set<MethodSignature> supportedMethodSignatures = new HashSet<MethodSignature>();

    private ObjectGetClassExecutor(ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        ClassVisitor getClassSignatureCollector = clazz -> this.supportedMethodSignatures.add(new MethodSignature(clazz.getName(), "getClass", "()Ljava/lang/Class;"));
        programClassPool.classesAccept(getClassSignatureCollector);
        libraryClassPool.classesAccept(getClassSignatureCollector);
    }

    @Override
    public MethodResult getMethodResult(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        if (!"getClass".equals(methodExecutionInfo.getSignature().getMethodName())) {
            throw new ProguardCoreException(9047, String.format("%s is not a supported method signature.", methodExecutionInfo.getSignature()), new Object[0]);
        }
        ReferenceValue instance = methodExecutionInfo.getInstanceNonStatic();
        if (!(instance instanceof TypedReferenceValue)) {
            return MethodResult.invalidResult();
        }
        TypedReferenceValue typedInstance = (TypedReferenceValue)instance;
        if (typedInstance.getType() == null) {
            return MethodResult.invalidResult();
        }
        Optional<Clazz> clazz = this.findReferencedClazz(ClassUtil.internalClassNameFromType(typedInstance.getType()));
        if (clazz.isPresent()) {
            return ObjectGetClassExecutor.createResult(methodExecutionInfo, valueCalculator, new ClassModel(clazz.get()));
        }
        return MethodResult.invalidResult();
    }

    @Override
    public Set<MethodSignature> getSupportedMethodSignatures() {
        return this.supportedMethodSignatures;
    }

    private Optional<Clazz> findReferencedClazz(@Nullable String className) {
        if (className == null) {
            return Optional.empty();
        }
        Clazz result = this.programClassPool.getClass(className = ClassUtil.internalClassName(className));
        return result != null ? Optional.of(result) : Optional.ofNullable(this.libraryClassPool.getClass(className));
    }

    private static MethodResult createResult(MethodExecutionInfo executionInfo, ValueCalculator valueCalculator, @Nullable Object concreteValue) {
        Value returnValue = valueCalculator.apply(executionInfo.getReturnType(), executionInfo.getReturnClass(), true, concreteValue, false, null);
        return new MethodResult.Builder().setReturnValue(returnValue).build();
    }

    public static class Builder
    implements Executor.Builder<ObjectGetClassExecutor> {
        private final ClassPool programClassPool;
        private final ClassPool libraryClassPool;
        private ObjectGetClassExecutor objectGetClassExecutor = null;

        public Builder(@NotNull ClassPool programClassPool, @NotNull ClassPool libraryClassPool) {
            this.programClassPool = programClassPool;
            this.libraryClassPool = libraryClassPool;
        }

        @Override
        public ObjectGetClassExecutor build() {
            if (this.objectGetClassExecutor == null) {
                this.objectGetClassExecutor = new ObjectGetClassExecutor(this.programClassPool, this.libraryClassPool);
            }
            return this.objectGetClassExecutor;
        }
    }
}

