/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object.model;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.model.ClassModel;
import proguard.evaluation.value.object.model.reflective.ModelHelper;
import proguard.evaluation.value.object.model.reflective.ModeledInstanceMethod;
import proguard.evaluation.value.object.model.reflective.ReflectiveModel;

public class ClassLoaderModel
implements ReflectiveModel<ClassLoaderModel> {
    @Override
    @NotNull
    public String getType() {
        return "Ljava/lang/ClassLoader;";
    }

    @Override
    public MethodResult init(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        throw new UnsupportedOperationException("Constructors invocation is not supported in " + this.getClass().getName());
    }

    @ModeledInstanceMethod(name="loadClass", descriptor="(Ljava/lang/String;)Ljava/lang/Class;")
    MethodResult loadClass(ModelHelper.MethodExecutionContext context, Value classNameValue) {
        if (!classNameValue.isParticular()) {
            return MethodResult.invalidResult();
        }
        Optional<Clazz> clazz = this.findReferencedClazz((String)classNameValue.referenceValue().getValue().getPreciseValue(), context.getExecutionInfo().getProgramClassPool(), context.getExecutionInfo().getLibraryClassPool());
        if (clazz.isPresent()) {
            return ModelHelper.createDefaultReturnResult(context, new ClassModel(clazz.get()));
        }
        return MethodResult.invalidResult();
    }

    @ModeledInstanceMethod(name="loadClass", descriptor="(Ljava/lang/String;Z)Ljava/lang/Class;")
    MethodResult loadClass(ModelHelper.MethodExecutionContext context, Value classNameValue, Value resolve) {
        if (!classNameValue.isParticular()) {
            return MethodResult.invalidResult();
        }
        Optional<Clazz> clazz = this.findReferencedClazz((String)classNameValue.referenceValue().getValue().getPreciseValue(), context.getExecutionInfo().getProgramClassPool(), context.getExecutionInfo().getLibraryClassPool());
        if (clazz.isPresent()) {
            return ModelHelper.createDefaultReturnResult(context, new ClassModel(clazz.get()));
        }
        return MethodResult.invalidResult();
    }

    @ModeledInstanceMethod(name="findLoadedClass", descriptor="(Ljava/lang/String;)Ljava/lang/Class;")
    MethodResult findLoadedClass(ModelHelper.MethodExecutionContext context, Value classNameValue) {
        if (!classNameValue.isParticular()) {
            return MethodResult.invalidResult();
        }
        Optional<Clazz> clazz = this.findReferencedClazz((String)classNameValue.referenceValue().getValue().getPreciseValue(), context.getExecutionInfo().getProgramClassPool(), context.getExecutionInfo().getLibraryClassPool());
        if (clazz.isPresent()) {
            return ModelHelper.createDefaultReturnResult(context, new ClassModel(clazz.get()));
        }
        return MethodResult.invalidResult();
    }

    private Optional<Clazz> findReferencedClazz(@Nullable String className, ClassPool programClassPool, ClassPool libraryClassPool) {
        if (className == null) {
            return Optional.empty();
        }
        Clazz result = programClassPool.getClass(className = ClassUtil.internalClassName(className));
        return result != null ? Optional.of(result) : Optional.ofNullable(libraryClassPool.getClass(className));
    }
}

