/*
 * Decompiled with CFR 0.152.
 */
package proguard.normalize;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.StringUtil;

public class LargeStringSplitter
implements ClassVisitor,
InstructionVisitor,
ConstantVisitor {
    private static final int MAX_STRING_SIZE = 65535;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final CodeAttributeEditor codeAttributeEditor;
    private final ConstantPoolShrinker constantPoolShrinker;
    private int offset;
    private boolean classModified = false;

    public LargeStringSplitter(ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.codeAttributeEditor = new CodeAttributeEditor();
        this.constantPoolShrinker = new ConstantPoolShrinker();
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.classModified = false;
        programClass.accept(new LargeStringClassConstantClassFilter(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeEditor(this.codeAttributeEditor, this)))));
        if (this.classModified) {
            programClass.accept(this.constantPoolShrinker);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.offset = offset;
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String fullString = stringConstant.getString(clazz);
        if (StringUtil.getModifiedUtf8Length(fullString) > 65535) {
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder((ProgramClass)clazz, this.programClassPool, this.libraryClassPool);
            ____.new_("java/lang/StringBuilder").dup().invokespecial("java/lang/StringBuilder", "<init>", "()V");
            int substringStart = 0;
            while (substringStart < fullString.length()) {
                int substringEnd = LargeStringSplitter.nextSubstringEnd(fullString, substringStart);
                ____.ldc(fullString.substring(substringStart, substringEnd)).invokevirtual("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                substringStart = substringEnd;
            }
            ____.invokevirtual("java/lang/Object", "toString", "()Ljava/lang/String;");
            this.codeAttributeEditor.replaceInstruction(this.offset, ____.__());
            this.classModified = true;
        }
    }

    private static int nextSubstringEnd(String fullString, int start) {
        int end;
        int maxLength = Integer.min(fullString.length(), start + 65535);
        for (end = start; end < maxLength && fullString.charAt(end) < '\u0080'; ++end) {
        }
        int utf8Length = end - start;
        while (end < maxLength) {
            char c = fullString.charAt(end);
            utf8Length = c < '\u0800' ? (utf8Length += 1 + (127 - c >>> 31)) : (utf8Length += 3);
            if (utf8Length > 65535) break;
            ++end;
        }
        return end;
    }

    private static class LargeStringClassConstantClassFilter
    implements ClassVisitor,
    ConstantVisitor {
        private final ClassVisitor acceptedVisitor;
        private boolean found;

        private LargeStringClassConstantClassFilter(ClassVisitor acceptedVisitor) {
            this.acceptedVisitor = acceptedVisitor;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            this.found = false;
            programClass.constantPoolEntriesAccept(this);
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            if (this.found) {
                return;
            }
            String fullString = stringConstant.getString(clazz);
            if (StringUtil.getModifiedUtf8Length(fullString) > 65535) {
                clazz.accept(this.acceptedVisitor);
                this.found = true;
            }
        }
    }
}

