/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.visitor.AllTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.util.kotlin.asserter.AssertUtil;
import proguard.util.kotlin.asserter.constraint.AbstractKotlinMetadataConstraint;

public class TypeIntegrity
extends AbstractKotlinMetadataConstraint
implements KotlinTypeVisitor {
    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        kotlinMetadata.accept(clazz, new AllTypeVisitor(this));
    }

    @Override
    public void visitAnyType(Clazz clazz, KotlinTypeMetadata type) {
        AssertUtil util = new AssertUtil("Type", this.reporter, this.programClassPool, this.libraryClassPool);
        if (type.className != null) {
            util.reportIfNullReference("class \"" + type.className + "\"", type.referencedClass);
            util.reportIfClassDangling("class \"" + type.className + "\"", type.referencedClass);
            if (type.aliasName != null) {
                this.reporter.report("Type cannot have both className (" + type.className + ") and aliasName (" + type.aliasName + ")");
            }
            if (type.typeParamID >= 0) {
                this.reporter.report("Type cannot have both className (" + type.className + ") and typeParamID (" + type.typeParamID + ")");
            }
        }
        if (type.aliasName != null) {
            util.reportIfNullReference("type alias \"" + type.aliasName + "\"", type.referencedTypeAlias);
            if (type.className != null) {
                this.reporter.report("Type cannot have both className (" + type.className + ") and aliasName (" + type.aliasName + ")");
            }
            if (type.typeParamID >= 0) {
                this.reporter.report("Type cannot have both aliasName (" + type.aliasName + ") and typeParamID (" + type.typeParamID + ")");
            }
        }
    }
}

