/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.IHasID;
import com.helger.commons.locale.country.ECountry;
import com.helger.commons.string.ToStringGenerator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CalendarHierarchy
implements IHasID<String> {
    private final String m_sID;
    private final ECountry m_eCountry;
    private final ICommonsMap<String, CalendarHierarchy> m_aChildren = new CommonsHashMap();

    public CalendarHierarchy(@Nullable CalendarHierarchy calendarHierarchy, @Nonnull String string, @Nullable ECountry eCountry) {
        ValueEnforcer.notNull((Object)string, (String)"ID");
        this.m_sID = calendarHierarchy == null ? string : calendarHierarchy.getID() + "_" + string;
        this.m_eCountry = eCountry;
    }

    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public String getDescription(Locale locale) {
        String string = this.m_eCountry == null ? null : this.m_eCountry.getDisplayText(locale);
        return string != null ? string : "undefined";
    }

    public void addChild(@Nonnull CalendarHierarchy calendarHierarchy) {
        this.m_aChildren.put((Object)calendarHierarchy.getID(), (Object)calendarHierarchy);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, CalendarHierarchy> getChildren() {
        return (ICommonsMap)this.m_aChildren.getClone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CalendarHierarchy calendarHierarchy = (CalendarHierarchy)object;
        return this.m_sID.equals(calendarHierarchy.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("country", (Enum)this.m_eCountry).getToString();
    }
}

