/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.mgr;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.locale.country.ECountry;
import com.helger.holiday.HolidayMap;
import com.helger.holiday.jaxb.Configuration;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.jaxb.ObjectFactory;
import com.helger.holiday.mgr.AbstractHolidayManager;
import com.helger.holiday.mgr.CalendarHierarchy;
import com.helger.holiday.parser.ChristianHolidayParser;
import com.helger.holiday.parser.EthiopianOrthodoxHolidayParser;
import com.helger.holiday.parser.FixedParser;
import com.helger.holiday.parser.FixedWeekdayBetweenFixedParser;
import com.helger.holiday.parser.FixedWeekdayInMonthParser;
import com.helger.holiday.parser.FixedWeekdayRelativeToFixedParser;
import com.helger.holiday.parser.HinduHolidayParser;
import com.helger.holiday.parser.IHolidayParser;
import com.helger.holiday.parser.IslamicHolidayParser;
import com.helger.holiday.parser.RelativeToFixedParser;
import com.helger.holiday.parser.RelativeToWeekdayInMonthParser;
import com.helger.jaxb.JAXBContextCache;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLHolidayManager
extends AbstractHolidayManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLHolidayManager.class);
    private final Configuration m_aConfiguration;

    @Nonnull
    private static Configuration _unmarshallConfiguration(@WillClose @Nonnull InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        try {
            JAXBContext jAXBContext = JAXBContextCache.getInstance().getFromCache(ObjectFactory.class);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)GenericReflection.uncheckedCast((Object)unmarshaller.unmarshal(inputStream));
            Configuration configuration = (Configuration)jAXBElement.getValue();
            return configuration;
        }
        catch (JAXBException jAXBException) {
            throw new IllegalArgumentException("Cannot parse holidays XML.", jAXBException);
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    public XMLHolidayManager(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CountryCode");
        String string2 = "holidays/Holidays_" + string.toLowerCase(CGlobal.DEFAULT_LOCALE) + ".xml";
        InputStream inputStream = ClassPathResource.getInputStream((String)string2);
        if (inputStream == null) {
            throw new IllegalArgumentException("No holidays are defined for country code '" + string + "'");
        }
        this.m_aConfiguration = XMLHolidayManager._unmarshallConfiguration(inputStream);
        XMLHolidayManager._validateConfigurationHierarchy(this.m_aConfiguration);
    }

    @Override
    public HolidayMap getHolidays(int n, String ... stringArray) {
        return this._getHolidays(n, this.m_aConfiguration, stringArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsList<IHolidayParser> _getParsers(@Nonnull Holidays holidays) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (!holidays.getChristianHoliday().isEmpty()) {
            commonsArrayList.add((Object)ChristianHolidayParser.getInstance());
        }
        if (!holidays.getEthiopianOrthodoxHoliday().isEmpty()) {
            commonsArrayList.add((Object)EthiopianOrthodoxHolidayParser.getInstance());
        }
        if (!holidays.getFixed().isEmpty()) {
            commonsArrayList.add((Object)FixedParser.getInstance());
        }
        if (!holidays.getFixedWeekdayBetweenFixed().isEmpty()) {
            commonsArrayList.add((Object)FixedWeekdayBetweenFixedParser.getInstance());
        }
        if (!holidays.getFixedWeekday().isEmpty()) {
            commonsArrayList.add((Object)FixedWeekdayInMonthParser.getInstance());
        }
        if (!holidays.getFixedWeekdayRelativeToFixed().isEmpty()) {
            commonsArrayList.add((Object)FixedWeekdayRelativeToFixedParser.getInstance());
        }
        if (!holidays.getHinduHoliday().isEmpty()) {
            commonsArrayList.add((Object)HinduHolidayParser.getInstance());
        }
        if (!holidays.getIslamicHoliday().isEmpty()) {
            commonsArrayList.add((Object)IslamicHolidayParser.getInstance());
        }
        if (!holidays.getRelativeToFixed().isEmpty()) {
            commonsArrayList.add((Object)RelativeToFixedParser.getInstance());
        }
        if (!holidays.getRelativeToWeekdayInMonth().isEmpty()) {
            commonsArrayList.add((Object)RelativeToWeekdayInMonthParser.getInstance());
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    private HolidayMap _getHolidays(int n, @Nonnull Configuration configuration, String ... stringArray) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding holidays for " + configuration.getDescription());
        }
        HolidayMap holidayMap = new HolidayMap();
        for (Object object : XMLHolidayManager._getParsers(configuration.getHolidays())) {
            object.parse(n, holidayMap, configuration.getHolidays());
        }
        if (ArrayHelper.isNotEmpty((Object[])stringArray)) {
            String string = stringArray[0];
            for (Configuration configuration2 : configuration.getSubConfigurations()) {
                if (!string.equalsIgnoreCase(configuration2.getHierarchy())) continue;
                HolidayMap holidayMap2 = this._getHolidays(n, configuration2, (String[])ArrayHelper.getCopy((Object[])stringArray, (int)1, (int)(stringArray.length - 1)));
                holidayMap.addAll(holidayMap2);
                break;
            }
        }
        return holidayMap;
    }

    private static void _validateConfigurationHierarchy(@Nonnull Configuration configuration) {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (Configuration configuration2 : configuration.getSubConfigurations()) {
            String string = configuration2.getHierarchy();
            if (commonsHashSet.add((Object)string)) continue;
            throw new IllegalArgumentException("Configuration for " + configuration.getHierarchy() + " contains multiple SubConfigurations with the same hierarchy id '" + string + "'. ");
        }
        for (Configuration configuration2 : configuration.getSubConfigurations()) {
            XMLHolidayManager._validateConfigurationHierarchy(configuration2);
        }
    }

    @Override
    @Nonnull
    public CalendarHierarchy getHierarchy() {
        return XMLHolidayManager._createConfigurationHierarchy(this.m_aConfiguration, null);
    }

    @Nonnull
    private static CalendarHierarchy _createConfigurationHierarchy(@Nonnull Configuration configuration, @Nullable CalendarHierarchy calendarHierarchy) {
        ECountry eCountry = ECountry.getFromIDOrNull((String)configuration.getHierarchy());
        CalendarHierarchy calendarHierarchy2 = new CalendarHierarchy(calendarHierarchy, configuration.getHierarchy(), eCountry);
        for (Configuration configuration2 : configuration.getSubConfigurations()) {
            CalendarHierarchy calendarHierarchy3 = XMLHolidayManager._createConfigurationHierarchy(configuration2, calendarHierarchy2);
            calendarHierarchy2.addChild(calendarHierarchy3);
        }
        return calendarHierarchy2;
    }
}

