/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.jaxb.RelativeToFixed;
import com.helger.holiday.jaxb.When;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.AbstractHolidayParser;
import java.time.LocalDate;

public final class RelativeToFixedParser
extends AbstractHolidayParser {
    private static final RelativeToFixedParser s_aInstance = new RelativeToFixedParser();

    private RelativeToFixedParser() {
    }

    public static RelativeToFixedParser getInstance() {
        return s_aInstance;
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (RelativeToFixed relativeToFixed : holidays.getRelativeToFixed()) {
            Object object;
            if (!RelativeToFixedParser.isValid(relativeToFixed, n)) continue;
            LocalDate localDate = XMLHolidayHelper.create(n, relativeToFixed.getDate());
            if (relativeToFixed.getWeekday() != null) {
                int n2;
                object = XMLHolidayHelper.getWeekday(relativeToFixed.getWeekday());
                int n3 = n2 = relativeToFixed.getWhen() == When.BEFORE ? -1 : 1;
                while ((localDate = localDate.plusDays(n2)).getDayOfWeek() != object) {
                }
            } else if (relativeToFixed.getDays() != null) {
                localDate = localDate.plusDays(relativeToFixed.getWhen() == When.BEFORE ? (long)(-relativeToFixed.getDays().intValue()) : (long)relativeToFixed.getDays().intValue());
            }
            object = XMLHolidayHelper.getType(relativeToFixed.getLocalizedType());
            String string = relativeToFixed.getDescriptionPropertiesKey();
            holidayMap.add(localDate, new ResourceBundleHoliday((IHolidayType)object, string));
        }
    }
}

