/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday;

import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.datetime.PDTFactory;
import com.helger.datetime.util.PDTHelper;
import java.time.LocalDate;
import java.time.Year;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.temporal.ChronoField;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CalendarHelper {
    private CalendarHelper() {
    }

    @Nonnull
    public static ICommonsSet<LocalDate> getIslamicHolidaysInGregorianYear(int n, int n2, int n3) {
        return CalendarHelper.getDatesFromChronologyWithinGregorianYear(n2, n3, n, HijrahChronology.INSTANCE);
    }

    @Nonnull
    public static ICommonsSet<LocalDate> getDatesFromChronologyWithinGregorianYear(int n, int n2, int n3, Chronology chronology) {
        Year year = Year.of(n3);
        ChronoLocalDate chronoLocalDate = chronology.date(year.atDay(1));
        ChronoLocalDate chronoLocalDate2 = chronology.date(year.atDay(365 + (year.isLeap() ? 1 : 0)));
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        int n4 = chronoLocalDate.get(ChronoField.YEAR);
        int n5 = chronoLocalDate2.get(ChronoField.YEAR);
        for (int i = n4; i <= n5; ++i) {
            ChronoLocalDate chronoLocalDate3 = chronology.date(i, n, n2);
            if (chronoLocalDate3.isBefore(chronoLocalDate) || chronoLocalDate3.isAfter(chronoLocalDate2)) continue;
            commonsHashSet.add((Object)LocalDate.from(chronoLocalDate3));
        }
        return commonsHashSet;
    }

    @Nonnull
    public static LocalDate getCurrentOrNextWorkDay() {
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        while (PDTHelper.isWeekend((LocalDate)localDate)) {
            localDate = localDate.plusDays(1L);
        }
        return localDate;
    }
}

