/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.jaxb.ChristianHoliday;
import com.helger.holiday.jaxb.ChronologyType;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.RelativeToEasterSundayParser;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import javax.annotation.Nonnull;

public final class ChristianHolidayParser
extends RelativeToEasterSundayParser {
    private static final ChristianHolidayParser s_aInstance = new ChristianHolidayParser();

    private ChristianHolidayParser() {
    }

    @Nonnull
    public static ChristianHolidayParser getInstance() {
        return s_aInstance;
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (ChristianHoliday christianHoliday : holidays.getChristianHoliday()) {
            if (!ChristianHolidayParser.isValid(christianHoliday, n)) continue;
            Object object = christianHoliday.getChronology() == ChronologyType.JULIAN ? ChristianHolidayParser.getJulianEasterSunday(n) : (christianHoliday.getChronology() == ChronologyType.GREGORIAN ? ChristianHolidayParser.getGregorianEasterSunday(n) : ChristianHolidayParser.getEasterSunday(n));
            switch (christianHoliday.getType()) {
                case EASTER: {
                    break;
                }
                case CLEAN_MONDAY: 
                case SHROVE_MONDAY: {
                    object = object.minus(48L, ChronoUnit.DAYS);
                    break;
                }
                case MARDI_GRAS: 
                case CARNIVAL: {
                    object = object.minus(47L, ChronoUnit.DAYS);
                    break;
                }
                case ASH_WEDNESDAY: {
                    object = object.minus(46L, ChronoUnit.DAYS);
                    break;
                }
                case MAUNDY_THURSDAY: {
                    object = object.minus(3L, ChronoUnit.DAYS);
                    break;
                }
                case GOOD_FRIDAY: {
                    object = object.minus(2L, ChronoUnit.DAYS);
                    break;
                }
                case EASTER_SATURDAY: {
                    object = object.minus(1L, ChronoUnit.DAYS);
                    break;
                }
                case EASTER_MONDAY: {
                    object = object.plus(1L, ChronoUnit.DAYS);
                    break;
                }
                case EASTER_TUESDAY: {
                    object = object.plus(2L, ChronoUnit.DAYS);
                    break;
                }
                case GENERAL_PRAYER_DAY: {
                    object = object.plus(26L, ChronoUnit.DAYS);
                    break;
                }
                case ASCENSION_DAY: {
                    object = object.plus(39L, ChronoUnit.DAYS);
                    break;
                }
                case PENTECOST: 
                case WHIT_SUNDAY: {
                    object = object.plus(49L, ChronoUnit.DAYS);
                    break;
                }
                case WHIT_MONDAY: 
                case PENTECOST_MONDAY: {
                    object = object.plus(50L, ChronoUnit.DAYS);
                    break;
                }
                case CORPUS_CHRISTI: {
                    object = object.plus(60L, ChronoUnit.DAYS);
                    break;
                }
                case SACRED_HEART: {
                    object = object.plus(68L, ChronoUnit.DAYS);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown christian holiday type " + (Object)((Object)christianHoliday.getType()));
                }
            }
            LocalDate localDate = LocalDate.from((TemporalAccessor)object);
            IHolidayType iHolidayType = XMLHolidayHelper.getType(christianHoliday.getLocalizedType());
            String string = "christian." + christianHoliday.getType().name();
            this.addChrstianHoliday(localDate, string, iHolidayType, holidayMap);
        }
    }
}

