/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.FixedWeekdayBetweenFixed;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.AbstractHolidayParser;
import java.time.DayOfWeek;
import java.time.LocalDate;

public final class FixedWeekdayBetweenFixedParser
extends AbstractHolidayParser {
    private static final FixedWeekdayBetweenFixedParser s_aInstance = new FixedWeekdayBetweenFixedParser();

    private FixedWeekdayBetweenFixedParser() {
    }

    public static FixedWeekdayBetweenFixedParser getInstance() {
        return s_aInstance;
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (FixedWeekdayBetweenFixed fixedWeekdayBetweenFixed : holidays.getFixedWeekdayBetweenFixed()) {
            if (!FixedWeekdayBetweenFixedParser.isValid(fixedWeekdayBetweenFixed, n)) continue;
            DayOfWeek dayOfWeek = XMLHolidayHelper.getWeekday(fixedWeekdayBetweenFixed.getWeekday());
            LocalDate localDate = XMLHolidayHelper.create(n, fixedWeekdayBetweenFixed.getFrom());
            LocalDate localDate2 = XMLHolidayHelper.create(n, fixedWeekdayBetweenFixed.getTo());
            LocalDate localDate3 = null;
            while (!localDate.isAfter(localDate2)) {
                if (localDate.getDayOfWeek() == dayOfWeek) {
                    localDate3 = localDate;
                    break;
                }
                localDate = localDate.plusDays(1L);
            }
            if (localDate3 == null) continue;
            IHolidayType iHolidayType = XMLHolidayHelper.getType(fixedWeekdayBetweenFixed.getLocalizedType());
            String string = fixedWeekdayBetweenFixed.getDescriptionPropertiesKey();
            holidayMap.add(localDate3, new ResourceBundleHoliday(iHolidayType, string));
        }
    }
}

