/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.datetime.util.PDTHelper;
import com.helger.holiday.CalendarHelper;
import com.helger.holiday.IHolidayManager;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HolidayHelper {
    private HolidayHelper() {
    }

    public static boolean isWorkDay(@Nonnull LocalDate localDate, @Nonnull IHolidayManager iHolidayManager) {
        return PDTHelper.isWorkDay((LocalDate)localDate) && !iHolidayManager.isHoliday(localDate, new String[0]);
    }

    public static int getWorkingDays(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2, @Nonnull IHolidayManager iHolidayManager) {
        ValueEnforcer.notNull((Object)localDate, (String)"StartDate");
        ValueEnforcer.notNull((Object)localDate2, (String)"EndDate");
        ValueEnforcer.notNull((Object)iHolidayManager, (String)"HolidayMgr");
        boolean bl = localDate.isAfter(localDate2);
        LocalDate localDate3 = bl ? localDate2 : localDate;
        LocalDate localDate4 = bl ? localDate : localDate2;
        int n = 0;
        while (!localDate4.isBefore(localDate3)) {
            if (HolidayHelper.isWorkDay(localDate3, iHolidayManager)) {
                ++n;
            }
            localDate3 = localDate3.plusDays(1L);
        }
        return bl ? -1 * n : n;
    }

    @Nonnull
    public static LocalDate getCurrentOrNextWorkDay(@Nullable IHolidayManager iHolidayManager) {
        if (iHolidayManager == null) {
            return CalendarHelper.getCurrentOrNextWorkDay();
        }
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        while (!HolidayHelper.isWorkDay(localDate, iHolidayManager)) {
            localDate = localDate.plusDays(1L);
        }
        return localDate;
    }
}

