/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.FixedWeekdayRelativeToFixed;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.jaxb.When;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.AbstractHolidayParser;
import java.time.DayOfWeek;
import java.time.LocalDate;

public final class FixedWeekdayRelativeToFixedParser
extends AbstractHolidayParser {
    private static final FixedWeekdayRelativeToFixedParser s_aInstance = new FixedWeekdayRelativeToFixedParser();

    private FixedWeekdayRelativeToFixedParser() {
    }

    public static FixedWeekdayRelativeToFixedParser getInstance() {
        return s_aInstance;
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (FixedWeekdayRelativeToFixed fixedWeekdayRelativeToFixed : holidays.getFixedWeekdayRelativeToFixed()) {
            if (!FixedWeekdayRelativeToFixedParser.isValid(fixedWeekdayRelativeToFixed, n)) continue;
            DayOfWeek dayOfWeek = XMLHolidayHelper.getWeekday(fixedWeekdayRelativeToFixed.getWeekday());
            LocalDate localDate = XMLHolidayHelper.create(n, fixedWeekdayRelativeToFixed.getDay());
            while ((localDate = fixedWeekdayRelativeToFixed.getWhen() == When.AFTER ? localDate.plusDays(1L) : localDate.minusDays(1L)).getDayOfWeek() != dayOfWeek) {
            }
            int n2 = 0;
            switch (fixedWeekdayRelativeToFixed.getWhich()) {
                case FIRST: {
                    break;
                }
                case SECOND: {
                    n2 = 7;
                    break;
                }
                case THIRD: {
                    n2 = 14;
                    break;
                }
                case FOURTH: {
                    n2 = 21;
                    break;
                }
            }
            localDate = fixedWeekdayRelativeToFixed.getWhen() == When.AFTER ? localDate.plusDays(n2) : localDate.minusDays(n2);
            IHolidayType iHolidayType = XMLHolidayHelper.getType(fixedWeekdayRelativeToFixed.getLocalizedType());
            String string = fixedWeekdayRelativeToFixed.getDescriptionPropertiesKey();
            holidayMap.add(localDate, new ResourceBundleHoliday(iHolidayType, string));
        }
    }
}

