/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class FederatedQueryOptions
extends GenericModel {
    private String environmentId;
    private String filter;
    private String query;
    private String naturalLanguageQuery;
    private Boolean passages;
    private String aggregation;
    private Long count;
    private String returnFields;
    private Long offset;
    private String sort;
    private Boolean highlight;
    private String passagesFields;
    private Long passagesCount;
    private Long passagesCharacters;
    private Boolean deduplicate;
    private String deduplicateField;
    private String collectionIds;
    private Boolean similar;
    private String similarDocumentIds;
    private String similarFields;
    private String bias;
    private Boolean loggingOptOut;

    private FederatedQueryOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        this.environmentId = builder.environmentId;
        this.filter = builder.filter;
        this.query = builder.query;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.passages = builder.passages;
        this.aggregation = builder.aggregation;
        this.count = builder.count;
        this.returnFields = builder.returnFields;
        this.offset = builder.offset;
        this.sort = builder.sort;
        this.highlight = builder.highlight;
        this.passagesFields = builder.passagesFields;
        this.passagesCount = builder.passagesCount;
        this.passagesCharacters = builder.passagesCharacters;
        this.deduplicate = builder.deduplicate;
        this.deduplicateField = builder.deduplicateField;
        this.collectionIds = builder.collectionIds;
        this.similar = builder.similar;
        this.similarDocumentIds = builder.similarDocumentIds;
        this.similarFields = builder.similarFields;
        this.bias = builder.bias;
        this.loggingOptOut = builder.loggingOptOut;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public Boolean passages() {
        return this.passages;
    }

    public String aggregation() {
        return this.aggregation;
    }

    public Long count() {
        return this.count;
    }

    public String returnFields() {
        return this.returnFields;
    }

    public Long offset() {
        return this.offset;
    }

    public String sort() {
        return this.sort;
    }

    public Boolean highlight() {
        return this.highlight;
    }

    public String passagesFields() {
        return this.passagesFields;
    }

    public Long passagesCount() {
        return this.passagesCount;
    }

    public Long passagesCharacters() {
        return this.passagesCharacters;
    }

    public Boolean deduplicate() {
        return this.deduplicate;
    }

    public String deduplicateField() {
        return this.deduplicateField;
    }

    public String collectionIds() {
        return this.collectionIds;
    }

    public Boolean similar() {
        return this.similar;
    }

    public String similarDocumentIds() {
        return this.similarDocumentIds;
    }

    public String similarFields() {
        return this.similarFields;
    }

    public String bias() {
        return this.bias;
    }

    public Boolean loggingOptOut() {
        return this.loggingOptOut;
    }

    public static class Builder {
        private String environmentId;
        private String filter;
        private String query;
        private String naturalLanguageQuery;
        private Boolean passages;
        private String aggregation;
        private Long count;
        private String returnFields;
        private Long offset;
        private String sort;
        private Boolean highlight;
        private String passagesFields;
        private Long passagesCount;
        private Long passagesCharacters;
        private Boolean deduplicate;
        private String deduplicateField;
        private String collectionIds;
        private Boolean similar;
        private String similarDocumentIds;
        private String similarFields;
        private String bias;
        private Boolean loggingOptOut;

        private Builder(FederatedQueryOptions federatedQueryOptions) {
            this.environmentId = federatedQueryOptions.environmentId;
            this.filter = federatedQueryOptions.filter;
            this.query = federatedQueryOptions.query;
            this.naturalLanguageQuery = federatedQueryOptions.naturalLanguageQuery;
            this.passages = federatedQueryOptions.passages;
            this.aggregation = federatedQueryOptions.aggregation;
            this.count = federatedQueryOptions.count;
            this.returnFields = federatedQueryOptions.returnFields;
            this.offset = federatedQueryOptions.offset;
            this.sort = federatedQueryOptions.sort;
            this.highlight = federatedQueryOptions.highlight;
            this.passagesFields = federatedQueryOptions.passagesFields;
            this.passagesCount = federatedQueryOptions.passagesCount;
            this.passagesCharacters = federatedQueryOptions.passagesCharacters;
            this.deduplicate = federatedQueryOptions.deduplicate;
            this.deduplicateField = federatedQueryOptions.deduplicateField;
            this.collectionIds = federatedQueryOptions.collectionIds;
            this.similar = federatedQueryOptions.similar;
            this.similarDocumentIds = federatedQueryOptions.similarDocumentIds;
            this.similarFields = federatedQueryOptions.similarFields;
            this.bias = federatedQueryOptions.bias;
            this.loggingOptOut = federatedQueryOptions.loggingOptOut;
        }

        public Builder() {
        }

        public Builder(String environmentId) {
            this.environmentId = environmentId;
        }

        public FederatedQueryOptions build() {
            return new FederatedQueryOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder passages(Boolean passages) {
            this.passages = passages;
            return this;
        }

        public Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder returnFields(String returnFields) {
            this.returnFields = returnFields;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder passagesFields(String passagesFields) {
            this.passagesFields = passagesFields;
            return this;
        }

        public Builder passagesCount(long passagesCount) {
            this.passagesCount = passagesCount;
            return this;
        }

        public Builder passagesCharacters(long passagesCharacters) {
            this.passagesCharacters = passagesCharacters;
            return this;
        }

        public Builder deduplicate(Boolean deduplicate) {
            this.deduplicate = deduplicate;
            return this;
        }

        public Builder deduplicateField(String deduplicateField) {
            this.deduplicateField = deduplicateField;
            return this;
        }

        public Builder collectionIds(String collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }

        public Builder similar(Boolean similar) {
            this.similar = similar;
            return this;
        }

        public Builder similarDocumentIds(String similarDocumentIds) {
            this.similarDocumentIds = similarDocumentIds;
            return this;
        }

        public Builder similarFields(String similarFields) {
            this.similarFields = similarFields;
            return this;
        }

        public Builder bias(String bias) {
            this.bias = bias;
            return this;
        }

        public Builder loggingOptOut(Boolean loggingOptOut) {
            this.loggingOptOut = loggingOptOut;
            return this;
        }
    }
}

